<?php

/**
 * i-doit
 *
 * CMDB - Reversed category for "nagios service" to "nagios service template".
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_ui_category_g_nagios_service_refs_tpl_backwards extends isys_cmdb_ui_category_global
{
    /**
     * Process method - Usually, we won't need this.
     *
     * @param   isys_cmdb_dao_category $p_cat
     *
     * @return  null
     */
    public function process(isys_cmdb_dao_category $p_cat)
    {
        return $this->process_list($p_cat);
    }

    /**
     * Method for processing the list-view.
     *
     * @param isys_cmdb_dao_category $p_cat
     * @param null                   $p_get_param_override
     * @param null                   $p_strVarName
     * @param null                   $p_strTemplateName
     * @param bool                   $p_bCheckbox
     * @param bool                   $p_bOrderLink
     * @param null                   $p_db_field_name
     *
     * @return boolean
     * @throws isys_exception_cmdb
     */
    public function process_list(
        isys_cmdb_dao_category &$p_cat,
        $p_get_param_override = null,
        $p_strVarName = null,
        $p_strTemplateName = null,
        $p_bCheckbox = true,
        $p_bOrderLink = true,
        $p_db_field_name = null
    ) {
        $this->object_browser_as_new([
            'name'                                          => 'C__CATG__NAGIOS_ASSIGNED_OBJECTS',
            isys_popup_browser_object_ng::C__MULTISELECTION => true,
            isys_popup_browser_object_ng::C__FORM_SUBMIT    => true,
            isys_popup_browser_object_ng::C__RETURN_ELEMENT => C__POST__POPUP_RECEIVER,
            isys_popup_browser_object_ng::C__CAT_FILTER     => 'C__CATG__NAGIOS_SERVICE_FOLDER',
            isys_popup_browser_object_ng::C__DATARETRIEVAL  => [
                ['isys_cmdb_dao_category_g_nagios_service_refs_tpl_backwards', "get_selected_objects"],
                $_GET[C__CMDB__GET__OBJECT],
                [
                    "isys_obj__id",
                    "isys_obj__title",
                    "isys_obj__isys_obj_type__id",
                    "isys_obj__sysid"
                ]
            ]
        ], 'LC__UNIVERSAL__OBJECT_ADD_REMOVE', 'LC__UNIVERSAL__OBJECT_ADD_REMOVE_DESCRIPTION');

        isys_component_template_navbar::getInstance()
            ->set_visible(false, C__NAVBAR_BUTTON__EDIT)
            ->set_visible(false, C__NAVBAR_BUTTON__ARCHIVE)
            ->set_visible(false, C__NAVBAR_BUTTON__PURGE)
            ->set_visible(false, C__NAVBAR_BUTTON__QUICK_PURGE);

        $this->list_view("isys_obj__id", $_GET[C__CMDB__GET__OBJECT],
            isys_cmdb_dao_list_catg_nagios_service_refs_tpl_backwards::build($this->get_database_component(), $p_cat));

        return true;
    }
}
