<?php

namespace idoit\Module\Packager\Component\Creator;

use idoit\Module\Packager\Component\Creator\Xml\CsvImportProfile as CsvImportProfileXml;
use idoit\Module\Packager\Component\Creator\Xml\CustomCategory as CustomCategoryXml;
use idoit\Module\Packager\Component\Creator\Xml\ObjectType as ObjectTypeXml;
use idoit\Module\Packager\Component\Creator\Xml\ObjectTypeGroup as ObjectTypeGroupXml;
use idoit\Module\Packager\Component\Creator\Xml\OverviewPageAssignment;
use idoit\Module\Packager\Component\Creator\Xml\RelationType as RelationTypeXml;
use idoit\Module\Packager\Component\Creator\Xml\Report as ReportXml;
use idoit\Module\Packager\Component\Creator\Xml\ReportCategory as ReportCategoryXml;
use idoit\Module\Packager\Configuration\Addon;
use idoit\Module\Packager\Model\CsvImportProfile;
use idoit\Module\Packager\Model\CustomCategory as CustomCategoryModel;
use idoit\Module\Packager\Model\ObjectType as ObjectTypeModel;
use idoit\Module\Packager\Model\ObjectTypeGroup as ObjectTypeGroupModel;
use idoit\Module\Packager\Model\RelationType as RelationTypeModel;
use idoit\Module\Packager\Model\Reports as ReportModel;
use isys_application;
use isys_cmdb_dao;
use isys_component_database;
use isys_format_json;
use SimpleXMLElement;

/**
 * Class UpdateXmlFile
 *
 * @package   idoit\Module\Packager\Component\Creator
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class UpdateXmlFile
{
    /**
     * @var string
     */
    private $addonPath;

    /**
     * StaticFile constructor.
     *
     * @param string $addonPath
     */
    public function __construct(string $addonPath)
    {
        $this->addonPath = $addonPath;
    }

    /**
     * Method for creating the package.json file.
     *
     * @param Addon                   $configuration
     * @param isys_component_database $database
     *
     * @throws \isys_exception_database
     */
    public function createUpdateXmlFile(Addon $configuration, isys_component_database $database)
    {
        $overviewPageAssignments = [];
        $objectTypeGroupModel = ObjectTypeGroupModel::instance($database);
        $objectTypeModel = ObjectTypeModel::instance($database);
        $customCategoryModel = CustomCategoryModel::instance($database);
        $reportModel = ReportModel::instance($database);
        $relationTypeModel = RelationTypeModel::instance($database);
        $csvImportProfileModel = CsvImportProfile::instance($database);

        // Create the XML root.
        $xml = new SimpleXMLElement('<isys></isys>');

        // Adding the "info" element.
        $infoNode = $xml->addChild('info');
        $infoNode->addChild('title', $configuration->title);
        $infoNode->addChild('version', $configuration->version);
        $infoNode->addChild('release', $configuration->releaseDate->format('Y-m-d'));

        // Add the "queries" element.
        $queriesNode = $xml->addChild('queries');

        if (!empty($configuration->assignedObjectTypeGroups) && \is_array($configuration->assignedObjectTypeGroups)) {
            foreach ($configuration->assignedObjectTypeGroups as $row) {
                (new ObjectTypeGroupXml($queriesNode))->appendXml(
                    $objectTypeGroupModel,
                    (string)$row['title'],
                    (string)$row['constant']
                );
            }
        }

        if (!empty($configuration->assignedObjectTypes) && \is_array($configuration->assignedObjectTypes)) {
            foreach ($configuration->assignedObjectTypes as $row) {
                // @see  PACKAGER-10  Write overview page assignments to a separate array for later.
                $overviewPageAssignments[(string)$row['constant']] = (array)$row['overviewAssignments'];

                (new ObjectTypeXml($queriesNode))->appendXml(
                    $objectTypeModel,
                    (string)$row['groupConstant'],
                    (string)$row['title'],
                    (bool)$row['selfdefined'],
                    (bool)$row['container'],
                    (string)$row['image'],
                    (string)$row['icon'],
                    (string)$row['constant'],
                    (int)$row['sort'],
                    (bool)$row['showInTree'],
                    (bool)$row['showInRack'],
                    (bool)$row['showOverview'],
                    (string)$row['color'],
                    (string)$row['className'],
                    (string)$row['sysidPrefix'],
                    (bool)$row['relationMaster'],
                    (bool)$row['templateTitle'],
                    $row['specificCategory'], // optional
                    $row['defaultTemplate'] // optional
                );
            }
        }

        if (!empty($configuration->assignedCustomCategories) && \is_array($configuration->assignedCustomCategories)) {
            foreach ($configuration->assignedCustomCategories as $row) {
                (new CustomCategoryXml($queriesNode))->appendXml(
                    $customCategoryModel,
                    (string)$row['title'],
                    (string)$row['configuration'],
                    (string)$row['constant'],
                    (bool)$row['listMultiValue']
                );
            }
        }

        // @see  PACKAGER-10  After adding the custom categories we can assign the categories to their overview pages.
        foreach ($overviewPageAssignments as $objectTypeConstant => $assignment) {
            (new OverviewPageAssignment($queriesNode))->appendXml(
                $objectTypeModel,
                $objectTypeConstant,
                $assignment['global'] ?: [],
                $assignment['custom'] ?: []
            );
        }

        if (!empty($configuration->selectedReports) && \is_array($configuration->selectedReports)) {
            foreach ($configuration->selectedReports as $row) {
                $categoryId = (int)$row['categoryId'];

                // The category with ID 1 is static (global category) and may not be altered.
                if ($categoryId > 0 && $categoryId !== 1 && !empty($row['categoryTitle']) && !empty($row['categoryConstant'])) {
                    (new ReportCategoryXml($queriesNode))->appendXml(
                        $reportModel,
                        (string)$row['categoryTitle'],
                        (string)$row['categoryConstant']
                    );
                }

                (new ReportXml($queriesNode))->appendXml(
                    $reportModel,
                    (string)$row['title'],
                    (string)$row['description'],
                    (string)$row['query'],
                    (string)$row['queryRow'],
                    (bool)$row['userSpecific'],
                    (string)$row['querybuilderData'],
                    (string)$row['categoryConstant'],
                    (bool)$row['emptyValues'],
                    (bool)$row['displayRelations'],
                    (bool)$row['categoryReport'],
                    (string)$row['constant'],
                    (bool)$row['compressedMultivalueResults'],
                    (bool)$row['showHtml']
                );
            }
        }

        if (!empty($configuration->selectedRelationTypes) && \is_array($configuration->selectedRelationTypes)) {
            foreach ($configuration->selectedRelationTypes as $row) {
                (new RelationTypeXml($queriesNode))->appendXml(
                    $relationTypeModel,
                    (string)$row['title'],
                    (string)$row['master'],
                    (string)$row['slave'],
                    (int)$row['type'],
                    (int)$row['defaultValue'],
                    (string)$row['constant'],
                    (string)$row['category'],
                    (bool)$row['editable'],
                    (int)$row['weightingId']
                );
            }
        }

        if (!empty($configuration->selectedCsvImportProfiles) && \is_array($configuration->selectedCsvImportProfiles)) {
            foreach ($configuration->selectedCsvImportProfiles as $row) {
                (new CsvImportProfileXml($queriesNode))->appendXml(
                    $csvImportProfileModel,
                    (string)$row['title'],
                    (string)$row['data']
                );
            }
        }

        // The next few lines are optional and format the XML nicely.
        $dom = dom_import_simplexml($xml)->ownerDocument;

        $dom->formatOutput = true;

        isys_file_put_contents($this->addonPath . 'install/update_data.xml', $dom->saveXML());
    }
}
