<?php

namespace idoit\Module\Packager\Component\Creator\Xml;

use idoit\Module\Packager\Model\ObjectTypeGroup as ObjectTypeGroupModel;

/**
 * Class ObjectTypeGroup
 *
 * @package   idoit\Module\Packager\Component\Creator\Xml
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class ObjectTypeGroup extends Query
{
    /**
     * @param ObjectTypeGroupModel $dao
     * @param string        $objectTypeGroupTitle
     * @param string        $objectTypeGroupConstant
     */
    public function appendXml(ObjectTypeGroupModel $dao, string $objectTypeGroupTitle, string $objectTypeGroupConstant)
    {
        // Not supported / necessary:
        // isys_obj_type_group__id
        // isys_obj_type_group__description
        // isys_obj_type_group__sort
        // isys_obj_type_group__property

        // Convert the variables so we can use the short string-concatenation form.
        $title = $dao->convert_sql_text($objectTypeGroupTitle);
        $constant = $dao->convert_sql_text($objectTypeGroupConstant);
        $normalStatus = $dao->convert_sql_int(C__RECORD_STATUS__NORMAL);

        $insertSql = "INSERT INTO isys_obj_type_group SET 
            isys_obj_type_group__title = {$title}, 
            isys_obj_type_group__const = {$constant}, 
            isys_obj_type_group__status = {$normalStatus};";

        $updateSql = "UPDATE isys_obj_type_group SET 
            isys_obj_type_group__title = {$title}, 
            isys_obj_type_group__status = {$normalStatus}
            WHERE isys_obj_type_group__const = {$constant}
            LIMIT 1;";

        parent::build(
            "Create object type group '{$objectTypeGroupTitle}'.",
            'C_VALUE_EXISTS',
            "SELECT isys_obj_type_group__id FROM isys_obj_type_group WHERE isys_obj_type_group__const = {$constant} LIMIT 1;",
            $updateSql,
            $insertSql
        );
    }
}
