<?php

namespace idoit\Module\Packager\Component\Creator\Xml;

use idoit\Module\Packager\Model\RelationType as RelationTypeModel;

/**
 * Class RelationType
 *
 * @package   idoit\Module\Packager\Component\Creator\Xml
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class RelationType extends Query
{
    /**
     * @param RelationTypeModel $dao
     * @param string            $relationTypeTitle
     * @param string            $master
     * @param string            $slave
     * @param int               $relationTypeType
     * @param int               $defaultValue
     * @param string            $constant
     * @param string            $category
     * @param bool              $isEditable
     * @param int               $weightingId
     */
    public function appendXml(
        RelationTypeModel $dao,
        string $relationTypeTitle,
        string $master,
        string $slave,
        int $relationTypeType,
        int $defaultValue,
        string $constant,
        string $category,
        bool $isEditable,
        int $weightingId
    ) {
        // Not supported / necessary:
        // isys_relation_type__id
        // isys_relation_type__sort
        // isys_relation_type__status

        // Convert the variables so we can use the short string-concatenation form.
        $title = $dao->convert_sql_text($relationTypeTitle);
        $master = $dao->convert_sql_text($master);
        $slave = $dao->convert_sql_text($slave);
        $type = $dao->convert_sql_int($relationTypeType);
        $default = $dao->convert_sql_int($defaultValue);
        $constant = $dao->convert_sql_text($constant);
        $category = $dao->convert_sql_text($category);
        $editable = $dao->convert_sql_boolean($isEditable);
        $normalStatus = $dao->convert_sql_int(C__RECORD_STATUS__NORMAL);
        $weight = $dao->convert_sql_id($weightingId);

        $insertSql = "INSERT INTO isys_relation_type SET 
            isys_relation_type__title = {$title}, 
            isys_relation_type__master = {$master}, 
            isys_relation_type__slave = {$slave}, 
            isys_relation_type__type = {$type}, 
            isys_relation_type__default = {$default}, 
            isys_relation_type__const = {$constant}, 
            isys_relation_type__category = {$category}, 
            isys_relation_type__editable = {$editable}, 
            isys_relation_type__status = {$normalStatus},
            isys_relation_type__isys_weighting__id = {$weight};";

        $updateSql = "UPDATE isys_relation_type SET 
            isys_relation_type__title = {$title}, 
            isys_relation_type__master = {$master}, 
            isys_relation_type__slave = {$slave}, 
            isys_relation_type__type = {$type}, 
            isys_relation_type__default = {$default}, 
            isys_relation_type__category = {$category}, 
            isys_relation_type__editable = {$editable}, 
            isys_relation_type__status = {$normalStatus},
            isys_relation_type__isys_weighting__id = {$weight}
            WHERE isys_relation_type__const = {$constant}
            LIMIT 1;";

        parent::build(
            "Create relation type '{$relationTypeTitle}'.",
            'C_VALUE_EXISTS',
            "SELECT isys_relation_type__id FROM isys_relation_type WHERE isys_relation_type__const = {$constant} LIMIT 1;",
            $updateSql,
            $insertSql
        );
    }
}
