<?php

namespace idoit\Module\Packager\Model;

use idoit\Model\Dao\Base;
use isys_component_dao_result;
use isys_exception_database;
use RuntimeException;

/**
 * Class CsvImportProfile
 *
 * @package   idoit\Module\Packager\Model
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class CsvImportProfile extends Base
{
    /**
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveForGui(): isys_component_dao_result
    {
        $select = $this->selectImplode([
            'isys_csv_profile__id'    => 'constant',
            'isys_csv_profile__title' => 'title',
        ]);

        return $this->retrieve("SELECT {$select} FROM isys_csv_profile;");
    }

    /**
     * @param array $ids
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveByIds(array $ids): isys_component_dao_result
    {
        if (empty($ids)) {
            throw new RuntimeException('At least one CSV import profile id has to be passed!');
        }

        $select = $this->selectImplode([
            'isys_csv_profile__title' => 'title',
            'isys_csv_profile__data'  => 'data',
        ]);

        $idList = implode(', ', array_map(function ($constant) { return $this->convert_sql_id($constant); }, $ids));

        return $this->retrieve("SELECT {$select} FROM isys_csv_profile WHERE isys_csv_profile__id IN ({$idList});");
    }
}
