<?php

namespace idoit\Module\Packager\Model;

use idoit\Model\Dao\Base;
use isys_component_dao_result;
use isys_exception_database;
use RuntimeException;

/**
 * Class CustomCategory
 *
 * @package   idoit\Module\Packager\Model
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class CustomCategory extends Base
{
    /**
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveForGui(): isys_component_dao_result
    {
        $select = $this->selectImplode([
            'isysgui_catg_custom__id'    => 'id',
            'isysgui_catg_custom__title' => 'title',
            'isysgui_catg_custom__const' => 'constant',
        ]);

        return $this->retrieve("SELECT {$select} FROM isysgui_catg_custom;");
    }

    /**
     * @param array $constants
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveByConstants(array $constants): isys_component_dao_result
    {
        if (empty($constants)) {
            throw new RuntimeException('At least one custom category constant has to be passed!');
        }

        $select = $this->selectImplode([
            'isysgui_catg_custom__type'             => 'type',
            'isysgui_catg_custom__title'            => 'title',
            'isysgui_catg_custom__config'           => 'configuration',
            'isysgui_catg_custom__parent'           => 'parent',
            'isysgui_catg_custom__sort'             => 'sort',
            'isysgui_catg_custom__const'            => 'constant',
            'isysgui_catg_custom__source_table'     => 'sourceTable',
            'isysgui_catg_custom__class_name'       => 'className',
            'isysgui_catg_custom__list_multi_value' => 'listMultiValue',
            'isysgui_catg_custom__status'           => 'status',
        ]);

        $constantList = implode(', ', array_map(function ($constant) { return $this->convert_sql_text($constant); }, $constants));

        return $this->retrieve("SELECT {$select} FROM isysgui_catg_custom WHERE isysgui_catg_custom__const IN ({$constantList});");
    }

    /**
     * @param string $customCategoryConstant
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveAssignedObjectTypes(string $customCategoryConstant): isys_component_dao_result
    {
        $convertedConstant = $this->convert_sql_text($customCategoryConstant);

        $sql = "SELECT isys_obj_type__const AS constant
            FROM isys_obj_type_2_isysgui_catg_custom
            INNER JOIN isys_obj_type ON isys_obj_type__id = isys_obj_type_2_isysgui_catg_custom__isys_obj_type__id
            INNER JOIN isysgui_catg_custom ON isysgui_catg_custom__id = isys_obj_type_2_isysgui_catg_custom__isysgui_catg_custom__id
            WHERE isysgui_catg_custom__const = {$convertedConstant};";

        return $this->retrieve($sql);
    }
}
