<?php

namespace idoit\Module\Packager\Model;

use idoit\Model\Dao\Base;
use isys_component_dao_result;

/**
 * Class FileRepository
 *
 * @package   idoit\Module\Packager\Model
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class FileRepository extends Base
{
    const FIELDS = [
        'isys_packager_file_repository__id'                           => 'id',
        'isys_packager_file_repository__isys_packager_repository__id' => 'repositoryId',
        'isys_packager_file_repository__title'                        => 'title',
        'isys_packager_file_repository__type'                         => 'type',
        'isys_packager_file_repository__content'                      => 'content',
        'isys_packager_file_repository__created'                      => 'created',
        'isys_packager_file_repository__description'                  => 'description',
        'isys_packager_file_repository__status'                       => 'status'
    ];

    /**
     * @param int $addonId
     * @param int $repositoryId
     *
     * @return bool
     * @throws \isys_exception_dao
     */
    public function transferFilesFromAddonToRepository(int $addonId, int $repositoryId): bool
    {
        // We use the "SQL INSERT INTO SELECT" syntax to save as much resources as possible.
        $insertIntoSelectQuery = "INSERT INTO isys_packager_file_repository (
            isys_packager_file_repository__isys_packager_repository__id,
            isys_packager_file_repository__title,
            isys_packager_file_repository__type,
            isys_packager_file_repository__content,
            isys_packager_file_repository__created,
            isys_packager_file_repository__description,
            isys_packager_file_repository__status
        ) 
        
        SELECT 
            {$repositoryId},
            isys_packager_file__title,
            isys_packager_file__type,
            isys_packager_file__content,
            isys_packager_file__updated,
            isys_packager_file__description,
            isys_packager_file__status
        FROM isys_packager_file
        WHERE isys_packager_file__isys_packager__id = {$addonId};";

        return $this->update($insertIntoSelectQuery) && $this->apply_update();
    }

    /**
     * @param int $id
     *
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function retrieveByRepositoryId(int $id): isys_component_dao_result
    {
        $select = $this->selectImplode([
            'isys_packager_file_repository__title'   => 'title',
            'isys_packager_file_repository__content' => 'content'
        ]);

        $repositoryId = $this->convert_sql_id($id);

        return $this->retrieve("SELECT {$select} FROM isys_packager_file_repository WHERE isys_packager_file_repository__isys_packager_repository__id = ({$repositoryId});");
    }
}
