<?php

namespace idoit\Module\Packager\Model;

use idoit\Model\Dao\Base;
use isys_component_dao_result;
use isys_exception_database;
use RuntimeException;

/**
 * Class RelationType
 *
 * @package   idoit\Module\Packager\Model
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class RelationType extends Base
{
    /**
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveForGui(): isys_component_dao_result
    {
        $select = $this->selectImplode([
            'isys_relation_type__id'    => 'id',
            'isys_relation_type__title' => 'title',
            'isys_relation_type__const' => 'constant',
        ]);

        // Get custom relation types (as defined as part of ID-7194).
        return $this->retrieve("SELECT {$select} FROM isys_relation_type WHERE isys_relation_type__const LIKE 'C__RELATION_TYPE_CUSTOM__%';");
    }

    /**
     * @param array $constants
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveByConstants(array $constants): isys_component_dao_result
    {
        if (empty($constants)) {
            throw new RuntimeException('At least one relation type constant has to be passed!');
        }

        $select = $this->selectImplode([
            'isys_relation_type__title'              => 'title',
            'isys_relation_type__master'             => 'master',
            'isys_relation_type__slave'              => 'slave',
            'isys_relation_type__type'               => 'type',
            'isys_relation_type__default'            => 'defaultValue',
            'isys_relation_type__const'              => 'constant',
            'isys_relation_type__category'           => 'category',
            'isys_relation_type__editable'           => 'editable',
            'isys_relation_type__status'             => 'status',
            'isys_relation_type__isys_weighting__id' => 'weightingId',
        ]);

        $constantList = implode(', ', array_map(function ($constant) { return $this->convert_sql_text($constant); }, $constants));

        return $this->retrieve("SELECT {$select} FROM isys_relation_type WHERE isys_relation_type__const IN ({$constantList});");
    }
}
