<?php

namespace idoit\Module\UpperCaseIdentifier\Processor;

use idoit\Module\UpperCaseIdentifier\Processor;
use isys_cmdb_dao;
use isys_custom_fields_dao;
use isys_report;

/**
 * Class Uninstall
 *
 * @package   idoit\Module\UpperCaseIdentifier\Processor
 * @copyright <manufacturer>
 * @license   <website>
 */
class Uninstall extends Processor
{
    /**
     * @return void
     * @throws \idoit\Exception\JsonException
     * @throws \isys_exception_dao
     * @throws \Exception
     */
    public function process()
    {
        /*
        // @see  PACKAGER-17  For now we won't remove object type groups when the add-on gets uninstalled.
        // Remove any created object type groups.
        $objectTypeGroups = $this->getDataFileContent('object-type-groups.json');

        if (\count($objectTypeGroups)) {
            $this->removeObjectTypeGroups($objectTypeGroups);
        }
        */

        // Remove any created custom categories.
        $customCategories = $this->getDataFileContent('custom-categories.json');

        if (\count($customCategories)) {
            $this->removeCustomCategories($customCategories);
        }

        // Remove any created reports.
        $reports = $this->getDataFileContent('reports.json');

        if (\count($reports)) {
            $this->removeReports($reports);
        }
    }

    /**
     * @param array $objectTypeGroups
     *
     * @return void
     * @throws \isys_exception_dao
     */
    private function removeObjectTypeGroups(array $objectTypeGroups)
    {
        $dao = isys_cmdb_dao::instance($this->database);

        // First we filter all "non-self-defined" object type groups.
        $objectTypeGroups = array_filter($objectTypeGroups, function ($objectTypeGroup) {
            return strpos($objectTypeGroup, 'C__OBJTYPE_GROUP__SD_') === 0;
        });

        // Then we "unify" and filter the array.
        $objectTypeGroups = array_filter(array_unique($objectTypeGroups));

        if (\count($objectTypeGroups) === 0) {
            return;
        }

        // Finally prepare the 'IN (...)' structure.
        $objectTypeGroupConstants = implode(',', array_map(function ($objectTypeGroup) use ($dao) {
            return $dao->convert_sql_text($objectTypeGroup['constant']);
        }, $objectTypeGroups));

        $dao->update("DELETE FROM isys_obj_type_group WHERE isys_obj_type_group__const IN ({$objectTypeGroupConstants});");
        $dao->apply_update();
    }

    /**
     * @param array $customCategories
     *
     * @return void
     * @throws \Exception
     */
    private function removeCustomCategories(array $customCategories)
    {
        $customCategoryDao = isys_custom_fields_dao::instance($this->database);

        foreach ($customCategories as $customCategory) {
            if (\defined($customCategory['constant'])) {
                $customCategoryId = \constant($customCategory['constant']);
            } else {
                $sql = 'SELECT isysgui_catg_custom__id AS id
                    FROM isysgui_catg_custom
                    WHERE isysgui_catg_custom__const = ' . $customCategoryDao->convert_sql_text($customCategory['constant']) . '
                    LIMIT 1;';

                $customCategoryId = (int)$customCategoryDao->retrieve($sql)->get_row_value('id');
            }

            if ($customCategoryId) {
                $customCategoryDao->delete($customCategoryId);
            }
        }
    }

    /**
     * @param array $reports
     *
     * @return void
     * @throws \Exception
     */
    private function removeReports(array $reports)
    {
        $reportDao = new isys_report([]);
        $cmdbDao = new isys_cmdb_dao($this->database);

        foreach ($reports as $report) {
            if (\defined($report['constant'])) {
                $reportId = \constant($report['constant']);
            } else {
                $sql = 'SELECT isys_report__id AS id
                    FROM isys_report
                    WHERE isys_report__const = ' . $cmdbDao->convert_sql_text($report['constant']) . '
                    LIMIT 1;';

                $reportId = (int)$cmdbDao->retrieve($sql)->get_row_value('id');
            }

            $reportDao->setId($reportId)->delete();
        }
    }
}
