<div id="add-on-packager-repository">

    <table class="contentTable">
        <tr>
            <td class="key"></td>
            <td class="value pl20">
                <button id="downloadPackage" type="button" class="btn">
                    <img src="[{$dir_images}]icons/silk/arrow_down.png" class="mr5" />
                    <span>[{isys type='lang' ident='LC__MODULE__PACKAGER__DOWNLOAD_PACKAGE'}]</span>
                </button>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <hr class="mt5 mb5" />
            </td>
        </tr>
        <tr>
            <td class="key">[{isys type='f_label' name='version' ident='LC__MODULE__PACKAGER__VERSION'}]</td>
            <td class="value">[{isys type='f_text' name='version'}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type='f_label' name='releaseDate' ident='LC__MODULE__PACKAGER__RELEASE_DATE'}]</td>
            <td class="value">[{isys type='f_text' name='releaseDate'}]</td>
        </tr>
        <tr>
            <td colspan="2">
                <hr class="mt5 mb5" />
            </td>
        </tr>
        <tr>
            <td class="key">[{isys type='f_label' name='title' ident='LC__MODULE__PACKAGER__TITLE'}]</td>
            <td class="value">[{isys type='f_text' name='title'}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type='f_label' name='manufacturer' ident='LC__MODULE__PACKAGER__MANUFACTURER' mandatory=true}]</td>
            <td class="value">[{isys type='f_text' name='manufacturer'}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type='f_label' name='website' ident='LC__MODULE__PACKAGER__WEBSITE'}]</td>
            <td class="value">[{isys type='f_text' name='website'}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type='f_label' name='requiresLicense' ident='LC__MODULE__PACKAGER__REQUIRES_LICENSE'}]</td>
            <td class="value">[{isys type='f_dialog' name='requiresLicense'}]</td>
        </tr>
        <tr>
            <td class="key vat">[{isys type='f_label' name='identifier' ident='LC__MODULE__PACKAGER__ADD_ON_IDENTIFIER' mandatory=true}]</td>
            <td class="value">[{isys type='f_text' name='identifier'}]</td>
        </tr>
        <tr>
            <td colspan="2">
                <hr class="mt5 mb5" />
            </td>
        </tr>
        <tr>
            <td class="key">[{isys type='f_label' name='idoitRequirement' ident='LC__MODULE__PACKAGER__IDOIT_REQUIREMENT'}]</td>
            <td class="value">[{isys type='f_text' name='idoitRequirement'}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type='f_label' name='createdOnPackagerVersion' ident='LC__MODULE__PACKAGER__CREATED_ON_PACKAGER_VERSION'}]</td>
            <td class="value">[{isys type='f_text' name='createdOnPackagerVersion'}]</td>
        </tr>
        <tr>
            <td class="key vat">[{isys type='f_label' name='description' ident='LC__MODULE__PACKAGER__DESCRIPTION'}]</td>
            <td class="value">[{isys type='f_textarea' name='description'}]</td>
        </tr>
        <tr>
            <td class="key vat">[{isys type='f_label' name='description' ident='LC__MODULE__PACKAGER__CHANGELOG'}]</td>
            <td class="value"><pre id="changelogView" class="box-white">[{$changelog}]</pre></td>
        </tr>
        <tr>
            <td colspan="2">
                <hr class="mt5 mb5" />
            </td>
        </tr>
    </table>

    <input type="hidden" name="repositoryId" value="[{$repositoryId}]" />
</div>

<style type="text/css">
    [{include file="`$packagerPath`assets/css/configuration.css"}]
</style>

<script type="text/javascript">
    (function () {
        "use strict";

        var $downloadPackageButton = $('downloadPackage');

        $downloadPackageButton.on('click', function () {
            $downloadPackageButton.disable();
            $downloadPackageButton
                .down('img').writeAttribute('src', window.dir_images + 'ajax-loading.gif')
                .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

            // Just in case the package does not exist, we'll trigger an AJAX request to go sure.
            new Ajax.Request(window.www_dir + 'packager/ajax/recreatePackage', {
                parameters: {
                    repositoryId: '[{$repositoryId}]'
                },
                onComplete: function (xhr) {
                    $downloadPackageButton.enable();
                    $downloadPackageButton
                        .down('img').writeAttribute('src', window.dir_images + 'icons/silk/arrow_down.png')
                        .next('span').update('[{isys type="lang" ident="LC__MODULE__PACKAGER__DOWNLOAD_PACKAGE"}]');

                    try {
                        if (!is_json_response(xhr)) {
                            throw 'Creating a package responded in a non-JSON response.';
                        }

                        var json = xhr.responseJSON;

                        if (!json.success) {
                            throw 'Creating a package did not go successfully: ' + json.message;
                        }

                        // We'll simply wait so the button gets re-set correctly.
                        setTimeout(function() {
                            // Redirect the browser to download the package.
                            document.location.href = '[{$baseUrl}]packager/main/download/[{$repositoryId}]';
                        }, 500);
                    } catch (e) {
                        idoit.Notify.error(e, {sticky: true});
                    }
                }
            });
        });
    }());
</script>
