<?php

namespace idoit\Module\Packager\Component\Creator;

use idoit\Module\Packager\Configuration\Addon;

/**
 * Class PackageJsonFile
 *
 * @package   idoit\Module\Packager\Component\Creator
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class PackageJsonFile
{
    /**
     * @var string
     */
    private $buildPath;

    /**
     * @var string
     */
    private $addonPath;

    /**
     * StaticFile constructor.
     *
     * @param string $buildPath
     * @param string $addonPath
     */
    public function __construct(string $buildPath, string $addonPath)
    {
        $this->buildPath = $buildPath;
        $this->addonPath = $addonPath;
    }

    /**
     * Method for creating the package.json file.
     *
     * @param Addon $configuration
     */
    public function createPackageJsonFile(Addon $configuration)
    {
        $files = [];

        $addonPathLength = mb_strlen($this->addonPath);
        $fileIterator = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($this->addonPath), \RecursiveIteratorIterator::CHILD_FIRST);

        foreach ($fileIterator as $file) {
            /** @var \SplFileInfo $file */
            if (strncmp($file->getBasename(), '.', 1) === 0) {
                // Skip "." and "..".
                continue;
            }

            $files[] = substr($file->getPathname(), $addonPathLength);
        }

        $content = [
            'name'         => $configuration->title,
            'identifier'   => $configuration->identifier,
            'author'       => $configuration->manufacturer,
            'version'      => $configuration->version,
            'description'  => $configuration->description,
            'type'         => 'addon',
            'files'        => $files,
            'sql-tables'   => [],
            'requirements' => [
                'core' => ">= {$configuration->idoitVersionRequirement}"
            ],
            'dependencies' => [
                'php' => [
                    'json',
                    'mysqli'
                ]
            ]
        ];

        if ($configuration->requiresLicense) {
            $content['licence'] = $configuration->identifier;
        }

        isys_file_put_contents($this->buildPath . 'package.json', \json_encode($content, JSON_UNESCAPED_SLASHES + JSON_PRETTY_PRINT));
    }
}
