<?php

namespace idoit\Module\Packager\Component\Creator;

/**
 * Class StaticFile
 *
 * @package   idoit\Module\Packager\Component\Creator
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class StaticFile
{
    /**
     * @var string
     */
    private $addonPath;

    /**
     * StaticFile constructor.
     *
     * @param string $addonPath
     */
    public function __construct(string $addonPath)
    {
        $this->addonPath = $addonPath;
    }

    /**
     * Method for creating our three basic static add-on files.
     *
     * @param string $changelog
     * @param string $version
     */
    public function createStaticFiles(string $changelog, string $version)
    {
        isys_file_put_contents($this->addonPath . 'CHANGELOG', $changelog);
        isys_file_put_contents($this->addonPath . 'VERSION', $version);
    }
}
