<?php

namespace idoit\Module\Packager\Component\Creator\Xml;

use idoit\Module\Packager\Model\CsvImportProfile as CsvImportProfileModel;

/**
 * Class CsvImportProfile
 *
 * @package   idoit\Module\Packager\Component\Creator\Xml
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class CsvImportProfile extends Query
{
    /**
     * @param CsvImportProfileModel $dao
     * @param string                $profileTitle
     * @param string                $profileData
     */
    public function appendXml(CsvImportProfileModel $dao, string $profileTitle, string $profileData)
    {
        // Not supported / necessary:
        // isys_csv_profile__id
        // Convert the variables so we can use the short string-concatenation form.
        $title = $dao->convert_sql_text($profileTitle);
        $data = $dao->convert_sql_text($profileData);

        $insertSql = "INSERT INTO isys_csv_profile SET 
            isys_csv_profile__title = {$title}, 
            isys_csv_profile__data = {$data};";

        $updateSql = "UPDATE isys_csv_profile SET 
            isys_csv_profile__title = {$title}, 
            isys_csv_profile__data = {$data}
            WHERE isys_csv_profile__title LIKE {$title}
            LIMIT 1;";

        parent::build(
            "Create CSV import profile '{$profileTitle}'.",
            'C_VALUE_EXISTS',
            "SELECT isys_csv_profile__id FROM isys_csv_profile WHERE isys_csv_profile__title = {$title} LIMIT 1;",
            $updateSql,
            $insertSql
        );
    }
}
