<?php

namespace idoit\Module\Packager\Component\Creator\Xml;

use idoit\Module\Packager\Model\ObjectType as ObjectTypeModel;

/**
 * Class ObjectType
 *
 * @package   idoit\Module\Packager\Component\Creator\Xml
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class ObjectType extends Query
{
    /**
     * @param ObjectTypeModel $dao
     * @param string        $objectTypeGroupConstant
     * @param string        $objectTypeTitle
     * @param bool          $selfdefined
     * @param bool          $container
     * @param string        $objectTypeImage
     * @param string        $objectTypeIcon
     * @param string        $objectTypeConstant
     * @param int           $objectTypeSort
     * @param bool          $showInTree
     * @param bool          $showInRack
     * @param bool          $showOverviewPage
     * @param string        $objectTypeColor
     * @param string        $objectTypeClassName
     * @param string        $objectTypeSysIdPrefix
     * @param bool          $objectTypeIsRelationMaster
     * @param bool          $objectTypeUsesTemplateTitle
     * @param string|null   $specificCategoryConstant
     * @param string|null   $defaultTemplateConstant
     */
    public function appendXml(
        ObjectTypeModel $dao,
        string $objectTypeGroupConstant,
        string $objectTypeTitle,
        bool $selfdefined,
        bool $container,
        string $objectTypeImage,
        string $objectTypeIcon,
        string $objectTypeConstant,
        int $objectTypeSort,
        bool $showInTree,
        bool $showInRack,
        bool $showOverviewPage,
        string $objectTypeColor,
        string $objectTypeClassName,
        string $objectTypeSysIdPrefix,
        bool $objectTypeIsRelationMaster,
        bool $objectTypeUsesTemplateTitle,
        string $specificCategoryConstant = null,
        string $defaultTemplateConstant = null
    ) {
        // Not supported / necessary:
        // isys_obj_type__id
        // isys_obj_type__description
        // isys_obj_type__idoit_obj_type_number
        // isys_obj_type__property
        // isys_obj_type__class_name

        // Convert the variables so we can use the short string-concatenation form.
        $group = $dao->convert_sql_text($objectTypeGroupConstant);
        $title = $dao->convert_sql_text($objectTypeTitle);
        $selfdefinedValue = $dao->convert_sql_boolean($selfdefined);
        $containerValue = $dao->convert_sql_boolean($container);
        $image = $dao->convert_sql_text($objectTypeImage);
        $icon = $dao->convert_sql_text($objectTypeIcon);
        $constant = $dao->convert_sql_text($objectTypeConstant);
        $sort = $dao->convert_sql_text($objectTypeSort);
        $normalStatus = $dao->convert_sql_int(C__RECORD_STATUS__NORMAL);
        $showInTreeValue = $dao->convert_sql_boolean($showInTree);
        $showInRackValue = $dao->convert_sql_boolean($showInRack);
        $overview = $dao->convert_sql_boolean($showOverviewPage);
        $color = $dao->convert_sql_text($objectTypeColor);
        $className = $dao->convert_sql_text($objectTypeClassName);
        $sysIdPrefix = $dao->convert_sql_text($objectTypeSysIdPrefix);
        $isRelationMaster = $dao->convert_sql_boolean($objectTypeIsRelationMaster);
        $useTemplateTitle = $dao->convert_sql_boolean($objectTypeUsesTemplateTitle);

        // Convert optional variables.
        $specificCategoryPart = '';
        $defaultTemplatePart = '';

        if (!empty($specificCategoryConstant)) {
            $specificCategory = $dao->convert_sql_text($specificCategoryConstant);
            $specificCategoryPart = "isys_obj_type__isysgui_cats__id = (SELECT isysgui_cats__id FROM isysgui_cats WHERE isysgui_cats__const = {$specificCategory} LIMIT 1),";
        }

        if (!empty($defaultTemplateConstant)) {
            $defaultTemplate = $dao->convert_sql_text($defaultTemplateConstant);
            $defaultTemplatePart = "isys_obj_type__default_template = (SELECT isysgui_cats__id FROM isysgui_cats WHERE isysgui_cats__const = {$defaultTemplate} LIMIT 1),";
        }

        $insertSql = "INSERT INTO isys_obj_type SET 
            isys_obj_type__isys_obj_type_group__id = (SELECT isys_obj_type_group__id FROM isys_obj_type_group WHERE isys_obj_type_group__const = {$group} LIMIT 1),
            {$specificCategoryPart}
            {$defaultTemplatePart}
            isys_obj_type__title = {$title}, 
            isys_obj_type__selfdefined = {$selfdefinedValue},
            isys_obj_type__container = {$containerValue},
            isys_obj_type__obj_img_name = {$image},
            isys_obj_type__icon = {$icon},
            isys_obj_type__const = {$constant},
            isys_obj_type__sort = {$sort},
            isys_obj_type__status = {$normalStatus},
            isys_obj_type__show_in_tree = {$showInTreeValue},
            isys_obj_type__show_in_rack = {$showInRackValue},
            isys_obj_type__overview = {$overview},
            isys_obj_type__color = {$color},
            isys_obj_type__class_name = {$className},
            isys_obj_type__sysid_prefix = {$sysIdPrefix},
            isys_obj_type__relation_master = {$isRelationMaster},
            isys_obj_type__use_template_title = {$useTemplateTitle};";

        $updateSql = "UPDATE isys_obj_type SET 
            isys_obj_type__isys_obj_type_group__id = (SELECT isys_obj_type_group__id FROM isys_obj_type_group WHERE isys_obj_type_group__const = {$group} LIMIT 1),
            {$specificCategoryPart}
            {$defaultTemplatePart}
            isys_obj_type__title = {$title}, 
            isys_obj_type__selfdefined = {$selfdefinedValue},
            isys_obj_type__container = {$containerValue},
            isys_obj_type__obj_img_name = {$image},
            isys_obj_type__icon = {$icon},
            isys_obj_type__sort = {$sort},
            isys_obj_type__status = {$normalStatus},
            isys_obj_type__show_in_tree = {$showInTreeValue},
            isys_obj_type__show_in_rack = {$showInRackValue},
            isys_obj_type__overview = {$overview},
            isys_obj_type__color = {$color},
            isys_obj_type__class_name = {$className},
            isys_obj_type__sysid_prefix = {$sysIdPrefix},
            isys_obj_type__relation_master = {$isRelationMaster},
            isys_obj_type__use_template_title = {$useTemplateTitle}
            WHERE isys_obj_type__const = {$constant}
            LIMIT 1;";

        parent::build(
            "Create object type '{$objectTypeTitle}'.",
            'C_VALUE_EXISTS',
            "SELECT isys_obj_type__id FROM isys_obj_type WHERE isys_obj_type__const = {$constant} LIMIT 1;",
            $updateSql,
            $insertSql
        );
    }
}
