<?php

namespace idoit\Module\Packager\Component\Creator\Xml;

use idoit\Module\Packager\Model\Reports as ReportModel;

/**
 * Class Report
 *
 * @package   idoit\Module\Packager\Component\Creator\Xml
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class ReportCategory extends Query
{
    /**
     * @param ReportModel $dao
     * @param string      $title
     * @param string      $constant
     */
    public function appendXml(ReportModel $dao, string $title, string $constant) {
        // Convert the variables so we can use the short string-concatenation form.
        $title = $dao->convert_sql_text($title);
        $constant = $dao->convert_sql_text($constant);

        $insertSql = "INSERT INTO isys_report_category SET 
            isys_report_category__title = {$title}, 
            isys_report_category__const = {$constant};";

        $updateSql = "UPDATE isys_report_category SET 
            isys_report_category__title = {$title} 
            WHERE isys_report_category__const = {$constant}
            LIMIT 1;";

        parent::build(
            "Create report category {$title}.",
            'C_VALUE_EXISTS',
            "SELECT isys_report_category__id FROM isys_report_category WHERE isys_report_category__const = {$constant} LIMIT 1;",
            $updateSql,
            $insertSql
        );
    }
}
