<?php

namespace idoit\Module\Packager\Model;

use idoit\Model\Dao\Base;
use isys_component_dao_result;
use isys_exception_database;
use RuntimeException;

/**
 * Class ObjectTypeGroup
 *
 * @package   idoit\Module\Packager\Model
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class ObjectTypeGroup extends Base
{
    /**
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveForGui(): isys_component_dao_result
    {
        $select = $this->selectImplode([
            'isys_obj_type_group__id'    => 'id',
            'isys_obj_type_group__title' => 'title',
            'isys_obj_type_group__const' => 'constant',
        ]);

        return $this->retrieve("SELECT {$select} FROM isys_obj_type_group;");
    }

    /**
     * @param array $constants
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveByConstants(array $constants): isys_component_dao_result
    {
        if (empty($constants)) {
            throw new RuntimeException('At least one object type group constant has to be passed!');
        }

        $select = $this->selectImplode([
            'isys_obj_type_group__title'       => 'title',
            'isys_obj_type_group__description' => 'description',
            'isys_obj_type_group__const'       => 'constant',
            'isys_obj_type_group__sort'        => 'sort',
            'isys_obj_type_group__status'      => 'status',
        ]);

        $constantList = implode(', ', array_map(function ($constant) { return $this->convert_sql_text($constant); }, $constants));

        return $this->retrieve("SELECT {$select} FROM isys_obj_type_group WHERE isys_obj_type_group__const IN ({$constantList});");
    }
}
