<?php

/**
 * Class isys_auth_packager
 *
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class isys_auth_packager extends isys_auth implements isys_auth_interface
{
    /**
     * Container for singleton instance.
     *
     * @var self
     */
    private static $instance;

    /**
     * Retrieve singleton instance of authorization class.
     *
     * @return isys_auth_packager
     */
    public static function instance(): self
    {
        // If the DAO has not been loaded yet, we initialize it now.
        if (self::$m_dao === null) {
            global $g_comp_database;

            self::$m_dao = new isys_auth_dao($g_comp_database);
        }

        if (self::$instance === null) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    /**
     * Method for returning the available auth-methods. This will be used for the GUI.
     *
     * @return array
     */
    public function get_auth_methods(): array
    {
        return [
            'packager'   => [
                'title'  => 'LC__MODULE__PACKAGER__AUTH__CONFIGURATION',
                'type'   => 'boolean',
                'rights' => [
                    isys_auth::VIEW,
                    isys_auth::EXECUTE
                ]
            ]
        ];
    }

    /**
     * @return int
     */
    public function get_module_id(): int
    {
        return C__MODULE__PACKAGER;
    }

    /**
     * @return string
     */
    public function get_module_title(): string
    {
        return 'LC__MODULE__PACKAGER';
    }
}
