<?php

namespace idoit\Module\Packager\Component\Creator;

use idoit\Module\Packager\Configuration\Addon;
use isys_format_json;

/**
 * Class PhpFile
 *
 * @package   idoit\Module\Packager\Component\Creator
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class PhpFile
{
    /**
     * @var string
     */
    private $addonPath;

    /**
     * @var string
     */
    private $addonTemplatePath;

    /**
     * StaticFile constructor.
     *
     * @param string $addonPath
     * @param string $addonTemplatePath
     */
    public function __construct(string $addonPath, string $addonTemplatePath)
    {
        $this->addonPath = $addonPath;
        $this->addonTemplatePath = $addonTemplatePath;
    }

    /**
     * Method for creating some PHP files.
     *
     * @param Addon $configuration
     */
    public function createPhpFiles(Addon $configuration)
    {
        $replacements = [
            'AddonTitle'                           => $configuration->title,
            'UpperCaseIdentifier'                  => ucfirst($configuration->identifier),
            'isys_module_tpl'                      => "isys_module_{$configuration->identifier}",
            'protected static $m_licenced = true;' => ($configuration->requiresLicense ? 'protected static $m_licenced = false;' : 'protected static $m_licenced = true;'),
            '<identifier>'                         => $configuration->identifier,
            '<manufacturer>'                       => $configuration->manufacturer,
            '<website>'                            => $configuration->website
        ];

        $files = [
            $this->addonTemplatePath . 'src/Processor/Activate.php'   => $this->addonPath . 'src/Processor/Activate.php',
            $this->addonTemplatePath . 'src/Processor/Deactivate.php' => $this->addonPath . 'src/Processor/Deactivate.php',
            $this->addonTemplatePath . 'src/Processor/Install.php'    => $this->addonPath . 'src/Processor/Install.php',
            $this->addonTemplatePath . 'src/Processor/Uninstall.php'  => $this->addonPath . 'src/Processor/Uninstall.php',
            $this->addonTemplatePath . 'src/Processor/Update.php'     => $this->addonPath . 'src/Processor/Update.php',
            $this->addonTemplatePath . 'src/Processor.php'            => $this->addonPath . 'src/Processor.php',
            $this->addonTemplatePath . 'isys_module_tpl.php'          => $this->addonPath . 'isys_module_' . $configuration->identifier . '.class.php',
            $this->addonTemplatePath . 'init.php'                     => $this->addonPath . 'init.php',
        ];

        foreach ($files as $sourceFile => $targetFile) {
            // First we load the file contents.
            $fileContent = file_get_contents($sourceFile);

            // Then we replace some parts of the files.
            $fileContent = strtr($fileContent, $replacements);

            // And finally create a add-on specific module files.
            isys_file_put_contents($targetFile, $fileContent);
        }
    }
}
