<?php /** @noinspection MagicMethodsValidityInspection */

namespace idoit\Module\Packager\Configuration;

use DateTime;

/**
 * Class Addon
 *
 * @property-read string   $identifier
 * @property-read string   $title
 * @property-read string   $description
 * @property-read string   $version
 * @property-read string   $manufacturer
 * @property-read string   $website
 * @property-read bool     $requiresLicense
 * @property-read string   $idoitVersionRequirement
 * @property-read DateTime $createdDate
 * @property-read DateTime $updatedDate
 * @property-read DateTime $releaseDate
 * @property-read string   $changelog
 * @property-read array    $assignedObjectTypeGroups
 * @property-read array    $assignedObjectTypes
 * @property-read array    $assignedCustomCategories
 * @property-read array    $selectedReports
 * @property-read string   $dialogPlusData
 * @property-read array    $selectedRelationTypes
 * @property-read array    $selectedCsvImportProfiles
 *
 * @package   idoit\Module\Packager\Configuration
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Addon
{
    /**
     * @var string
     */
    private $identifier;

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $description;

    /**
     * @var string
     */
    private $version;

    /**
     * @var string
     */
    private $manufacturer;

    /**
     * @var string
     */
    private $website;

    /**
     * @var bool
     */
    private $requiresLicense;

    /**
     * @var string
     */
    private $idoitVersionRequirement;

    /**
     * @var DateTime
     */
    private $createdDate;

    /**
     * @var DateTime
     */
    private $updatedDate;

    /**
     * @var DateTime
     */
    private $releaseDate;

    /**
     * @var string
     */
    private $changelog;

    /**
     * @var array
     */
    private $assignedObjectTypeGroups = [];

    /**
     * @var array
     */
    private $assignedObjectTypes = [];

    /**
     * @var array
     */
    private $assignedCustomCategories = [];

    /**
     * @var array
     */
    private $selectedReports = [];

    /**
     * @var string
     */
    private $dialogPlusData;

    /**
     * @var array
     */
    private $selectedRelationTypes = [];

    /**
     * @var array
     */
    private $selectedCsvImportProfiles = [];

    /**
     * Addon constructor.
     *
     * @param string   $identifier
     * @param string   $title
     * @param string   $description
     * @param string   $version
     * @param string   $manufacturer
     * @param string   $website
     * @param bool     $requiresLicense
     * @param string   $idoitVersionRequirement
     * @param DateTime $createdDate
     * @param DateTime $updatedDate
     * @param DateTime $releaseDate
     * @param string   $changelog
     * @param array    $assignedObjectTypeGroups
     * @param array    $assignedObjectTypes
     * @param array    $assignedCustomCategories
     * @param array    $selectedReports
     * @param string   $dialogPlusData
     * @param array    $selectedRelationTypes
     * @param array    $selectedCsvImportProfiles
     */
    public function __construct(
        string $identifier,
        string $title,
        string $description,
        string $version,
        string $manufacturer,
        string $website,
        bool $requiresLicense,
        string $idoitVersionRequirement,
        DateTime $createdDate,
        DateTime $updatedDate,
        DateTime $releaseDate,
        string $changelog,
        array $assignedObjectTypeGroups,
        array $assignedObjectTypes,
        array $assignedCustomCategories,
        array $selectedReports,
        string $dialogPlusData,
        array $selectedRelationTypes,
        array $selectedCsvImportProfiles
    ) {
        $this->identifier = $identifier;
        $this->title = $title;
        $this->description = $description;
        $this->version = $version;
        $this->manufacturer = $manufacturer;
        $this->website = $website;
        $this->requiresLicense = $requiresLicense;
        $this->idoitVersionRequirement = $idoitVersionRequirement;
        $this->createdDate = $createdDate;
        $this->updatedDate = $updatedDate;
        $this->releaseDate = $releaseDate;
        $this->changelog = $changelog;
        $this->assignedObjectTypeGroups = $assignedObjectTypeGroups;
        $this->assignedObjectTypes = $assignedObjectTypes;
        $this->assignedCustomCategories = $assignedCustomCategories;
        $this->selectedReports = $selectedReports;
        $this->dialogPlusData = $dialogPlusData;
        $this->selectedRelationTypes = $selectedRelationTypes;
        $this->selectedCsvImportProfiles = $selectedCsvImportProfiles;
    }

    /**
     * Retrieves a property of this class.
     *
     * @param string $name
     *
     * @return mixed
     */
    public function __get(string $name)
    {
        if (property_exists($this, $name)) {
            return $this->$name;
        }

        return null;
    }

    /**
     * This method is necessary for calls like `empty($config->assignedObjectTypeGroups)`.
     *
     * @param string $name
     *
     * @return bool
     */
    public function __isset($name)
    {
        return property_exists($this, $name);
    }
}
