<?php

namespace idoit\Module\Packager\Controller;

use idoit\Module\Packager\View\Repository as RepositoryView;
use idoit\Module\Packager\View\RepositoryList;
use idoit\View\Renderable;
use isys_application as Application;
use isys_auth;
use isys_exception_database;
use isys_module_packager as ModulePackager;
use isys_register as Register;

/**
 * Class Repository
 *
 * @package   idoit\Module\Packager\Controller
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Repository extends Main
{
    /**
     * Default request handler, gets called in every request.
     *
     * @param Register    $request
     * @param Application $application
     *
     * @return void
     * @throws \isys_exception_auth
     */
    public function handle(Register $request, Application $application)
    {
        // Check if the user is allowed to see this add-on.
        ModulePackager::getAuth()->check(isys_auth::VIEW, 'packager');
    }

    /**
     * @param Register    $request
     * @param Application $application
     *
     * @return Renderable
     * @throws isys_exception_database
     */
    public function onDefault(Register $request, Application $application)
    {
        if ($request->get('id') > 0) {
            return (new RepositoryView($request))->setID((int)$request->get('id'));
        }

        return new RepositoryList($request);
    }
}
