<?php

namespace idoit\Module\Packager\View;

use Exception;
use idoit\Model\Dao\Base as DaoBase;
use idoit\Module\Packager\Model\Addon as AddonModel;
use idoit\Module\Packager\Model\Repository;
use idoit\View\Base;
use isys_application as Application;
use isys_component_list as ComponentList;
use isys_component_template as ComponentTemplate;
use isys_component_template_navbar as ComponentNavbar;
use isys_module as ModuleBase;
use isys_module_packager;

/**
 * Class AddonList
 *
 * @package   idoit\Module\Packager\View
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class AddonList extends Base
{
    /**
     * @param ModuleBase        $module
     * @param ComponentTemplate $template
     * @param DaoBase           $model
     *
     * @return $this
     */
    public function process(ModuleBase $module, ComponentTemplate $template, DaoBase $model)
    {
        // Set paths to templates.
        $this->paths['contentbottomcontent'] = $module::getPath() . 'templates/main.tpl';

        // Auth instance.
        $auth = isys_module_packager::getAuth();

        // Prepare the navbar.
        ComponentNavbar::getInstance()
            ->set_active($auth->is_allowed_to($auth::EXECUTE, 'packager'), C__NAVBAR_BUTTON__NEW)
            ->set_active($auth->is_allowed_to($auth::EXECUTE, 'packager'), C__NAVBAR_BUTTON__EDIT)
            ->set_active($auth->is_allowed_to($auth::EXECUTE, 'packager'), C__NAVBAR_BUTTON__DELETE);

        $addonModel = AddonModel::instance(Application::instance()->container->get('database'));

        // Get list component.
        $listComponent = new ComponentList();
        $listComponent->set_row_modifier($this, 'rowModifier');
        $listComponent->config([
            'id'         => 'LC__MODULE__PACKAGER__ID',
            'title'      => 'LC__MODULE__PACKAGER__TITLE',
            'version'    => 'LC__MODULE__PACKAGER__LATEST_VERSION',
            'identifier' => 'LC__MODULE__PACKAGER__ADD_ON_IDENTIFIER',
            'created'    => 'LC__MODULE__PACKAGER__CREATED',
            'updated'    => 'LC__MODULE__PACKAGER__UPDATED',
        ], \isys_core::request_url() . 'packager/main/[{id}]', '[{id}]');

        $template->assign('tableComponent', $listComponent->getTempTableHtml($addonModel->getAddonList()))
            ->smarty_tom_add_rule('tom.content.bottom.buttons.*.p_bInvisible=1')
            ->smarty_tom_add_rule('tom.content.navbar.cRecStatus.p_bInvisible=1');

        return $this;
    }

    /**
     * @param array &$row
     *
     * @throws \isys_exception_locale
     */
    public function rowModifier(&$row)
    {
        try {
            $locale = Application::instance()->container->get('locales');

            $row['created'] = $locale->fmt_datetime($row['created']);
            $row['updated'] = $locale->fmt_datetime($row['updated']);
            $row['version'] = Repository::instance(Application::instance()->container->get('database'))
                ->getLatestVersionOfAddon($row['id'])
                ->get_row_value('version');
        } catch (Exception $e) {

        }
    }
}
