<?php
/**
 * init.php
 *
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Component\Download\DownloadType;
use idoit\Module\Packager\Controller\Main;
use idoit\Psr4AutoloaderClass;

if (isys_module_manager::instance()->is_active('packager')) {
    Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Packager', __DIR__ . '/src/');

    Autoloader::appendClassmap(require_once __DIR__ . '/classmap.php');

    isys_application::instance()->container->get('download')
        ->registerDownloadType('packager.add-on-package', new DownloadType([Main::class, 'download']));
}
