<?php

use idoit\AddOn\ActivatableInterface;
use idoit\AddOn\AuthableInterface;
use idoit\AddOn\InstallableInterface;

/**
 * Class isys_module_packager
 *
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class isys_module_packager extends isys_module implements AuthableInterface, InstallableInterface, ActivatableInterface
{
    // Define, if this module shall be displayed in the named menus.
    const DISPLAY_IN_MAIN_MENU   = true;
    const DISPLAY_IN_SYSTEM_MENU = false;
    const MAIN_MENU_REWRITE_LINK = true;

    /**
     * @var bool
     */
    protected static $m_licenced = true;

    /**
     * Get related auth class for module.
     *
     * @return \isys_auth
     */
    public static function getAuth()
    {
        return isys_auth_packager::instance();
    }

    /**
     * Initializes the module.
     *
     * @param isys_module_request $request
     */
    public function init(isys_module_request $request)
    {
    }

    /**
     * Build breadcrumb navifation
     *
     * @param &$get
     *
     * @return array
     */
    public function breadcrumb_get(&$get)
    {
        return [
            [
                $this->language->get('LC__MODULE__PACKAGER__ADD_ON_LIST') => [
                    C__GET__MODULE_ID => C__MODULE__PACKAGER
                ]
            ]
        ];
    }

    /**
     * Checks if a add-on is installed.
     *
     * @return int|bool
     */
    public static function isInstalled()
    {
        return isys_module_manager::instance()->is_installed('packager');
    }

    /**
     * Basic installation process for all mandators.
     *
     * @param isys_component_database $tenantDatabase
     * @param isys_component_database $systemDatabase
     * @param integer                 $moduleId
     * @param string                  $type
     * @param integer                 $tenantId
     *
     * @return bool
     */
    public static function install($tenantDatabase, $systemDatabase, $moduleId, $type, $tenantId)
    {
        return true;
    }

    /**
     * Uninstall add-on for all mandators.
     *
     * @param isys_component_database $tenantDatabase
     *
     * @return bool
     */
    public static function uninstall($tenantDatabase)
    {
        return true;
    }

    /**
     * Checks if a add-on is active.
     *
     * @return integer|bool
     */
    public static function isActive()
    {
        return isys_module_manager::instance()->is_installed('packager', true);
    }

    /**
     * Method that is called after clicking "activate" in admin center for specific mandator.
     *
     * @param isys_component_database $tenantDatabase
     *
     * @return bool
     */
    public static function activate($tenantDatabase)
    {
        return true;
    }

    /**
     * Method that is called after clicking "deactivate" in admin center for specific mandator.
     *
     * @param isys_component_database $tenantDatabase
     *
     * @return bool
     */
    public static function deactivate($tenantDatabase)
    {
        return true;
    }
}
