<?php

namespace idoit\Module\Packager\Component\Creator;

use RuntimeException;

/**
 * Class Directory
 *
 * @package   idoit\Module\Packager\Component\Creator
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Directory
{
    /**
     * @var string
     */
    private $addonPath;

    /**
     * Directory constructor.
     *
     * @param $addonPath
     */
    public function __construct(string $addonPath)
    {
        $this->addonPath = $addonPath;
    }

    /**
     * @param array $directories
     *
     * @return bool
     * @throws RuntimeException
     */
    public function createDirectories(array $directories): bool
    {
        foreach ($directories as $directory) {
            $path = $this->addonPath . $directory;

            if (!mkdir($path, 0755, true) && !is_dir($path)) {
                throw new RuntimeException("The directory '{$path}' could not be created, please check if the filesystem rights have been set correctly.");
            }
        }

        return true;
    }
}
