<?php

namespace idoit\Module\Packager\Component\Creator\Xml;

use idoit\Module\Packager\Model\CustomCategory as CustomCategoryModel;
use isys_cmdb_dao_category;

/**
 * Class CustomCategory
 *
 * @package   idoit\Module\Packager\Component\Creator\Xml
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class CustomCategory extends Query
{
    /**
     * @param CustomCategoryModel $dao
     * @param string        $categoryTitle
     * @param string        $categoryConfiguration
     * @param string        $categoryConstant
     * @param bool          $isMultiValued
     */
    public function appendXml(CustomCategoryModel $dao, string $categoryTitle, string $categoryConfiguration, string $categoryConstant, bool $isMultiValued)
    {
        // Not supported / necessary:
        // isysgui_catg_custom__id
        // isysgui_catg_custom__parent
        // isysgui_catg_custom__sort
        // isysgui_catg_custom__source_table
        // isysgui_catg_custom__class_name

        // Convert the variables so we can use the short string-concatenation form.
        $type = $dao->convert_sql_int(isys_cmdb_dao_category::TYPE_EDIT);
        $title = $dao->convert_sql_text($categoryTitle);
        $configuration = $dao->convert_sql_text($categoryConfiguration);
        $constant = $dao->convert_sql_text($categoryConstant);
        $multiValue = $dao->convert_sql_boolean($isMultiValued);
        $normalStatus = $dao->convert_sql_int(C__RECORD_STATUS__NORMAL);

        $insertSql = "INSERT INTO isysgui_catg_custom SET 
            isysgui_catg_custom__type = {$type}, 
            isysgui_catg_custom__title = {$title}, 
            isysgui_catg_custom__config = {$configuration}, 
            isysgui_catg_custom__parent = 0, 
            isysgui_catg_custom__list_multi_value = {$multiValue}, 
            isysgui_catg_custom__const = {$constant}, 
            isysgui_catg_custom__status = {$normalStatus};";

        $updateSql = "UPDATE isysgui_catg_custom SET 
            isysgui_catg_custom__type = {$type}, 
            isysgui_catg_custom__title = {$title}, 
            isysgui_catg_custom__config = {$configuration}, 
            isysgui_catg_custom__parent = 0, 
            isysgui_catg_custom__list_multi_value = {$multiValue}, 
            isysgui_catg_custom__status = {$normalStatus}
            WHERE isysgui_catg_custom__const = {$constant}
            LIMIT 1;";

        parent::build(
            "Create custom category '$categoryTitle'.",
            'C_VALUE_EXISTS',
            "SELECT isysgui_catg_custom__id FROM isysgui_catg_custom WHERE isysgui_catg_custom__const = {$constant} LIMIT 1;",
            $updateSql,
            $insertSql
        );
    }
}
