<?php

namespace idoit\Module\Packager\Component\Creator\Xml;

use idoit\Module\Packager\Model\ObjectType as ObjectTypeModel;

/**
 * Class OverviewPageAssignment
 *
 * @package   idoit\Module\Packager\Component\Creator\Xml
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class OverviewPageAssignment extends Query
{
    /**
     * @param ObjectTypeModel $dao
     * @param string          $objectTypeConstant
     * @param array           $globalCategories
     * @param array           $customCategories
     */
    public function appendXml(ObjectTypeModel $dao, string $objectTypeConstant, array $globalCategories, array $customCategories)
    {
        $constant = $dao->convert_sql_text($objectTypeConstant);

        if (\count($globalCategories)) {
            foreach ($globalCategories as $sort => $globalCategory) {
                $categoryConstant = $dao->convert_sql_text($globalCategory);

                $checkConditionSql = "SELECT * 
                    FROM isys_obj_type_2_isysgui_catg_overview
                    WHERE isys_obj_type__id = (SELECT isys_obj_type__id FROM isys_obj_type WHERE isys_obj_type__const = {$constant} LIMIT 1)
                    AND isysgui_catg__id = (SELECT isysgui_catg__id FROM isysgui_catg WHERE isysgui_catg__const = {$categoryConstant} LIMIT 1) 
                    LIMIT 1;";

                $updateSql = "UPDATE isys_obj_type_2_isysgui_catg_overview 
                    SET isys_obj_type_2_isysgui_catg_overview__sort = {$sort}
                    WHERE isys_obj_type__id = (SELECT isys_obj_type__id FROM isys_obj_type WHERE isys_obj_type__const = {$constant} LIMIT 1)
                    AND isysgui_catg__id = (SELECT isysgui_catg__id FROM isysgui_catg WHERE isysgui_catg__const = {$categoryConstant} LIMIT 1);";

                $insertSql = "INSERT INTO isys_obj_type_2_isysgui_catg_overview 
                    SET isys_obj_type__id = (SELECT isys_obj_type__id FROM isys_obj_type WHERE isys_obj_type__const = {$constant} LIMIT 1),
                    isysgui_catg__id = (SELECT isysgui_catg__id FROM isysgui_catg WHERE isysgui_catg__const = {$categoryConstant} LIMIT 1),
                    isys_obj_type_2_isysgui_catg_overview__sort = {$sort};";

                parent::build(
                    "Create overview page assignment between object type '{$objectTypeConstant}' and global category {$globalCategory}.",
                    'C_VALUE_EXISTS',
                    $checkConditionSql,
                    $updateSql,
                    $insertSql
                );
            }
        }

        if (\count($customCategories)) {
            foreach ($customCategories as $sort => $customCategory) {
                $categoryConstant = $dao->convert_sql_text($customCategory);

                $checkConditionSql = "SELECT * 
                    FROM isys_obj_type_2_isysgui_catg_custom_overview
                    WHERE isys_obj_type__id = (SELECT isys_obj_type__id FROM isys_obj_type WHERE isys_obj_type__const = {$constant} LIMIT 1)
                    AND isysgui_catg_custom__id = (SELECT isysgui_catg_custom__id FROM isysgui_catg_custom WHERE isysgui_catg_custom__const = {$categoryConstant} LIMIT 1)
                    LIMIT 1;";

                $updateSql = "UPDATE isys_obj_type_2_isysgui_catg_custom_overview 
                    SET isys_obj_type_2_isysgui_catg_custom_overview__sort = {$sort}
                    WHERE isys_obj_type__id = (SELECT isys_obj_type__id FROM isys_obj_type WHERE isys_obj_type__const = {$constant} LIMIT 1)
                    AND isysgui_catg_custom__id = (SELECT isysgui_catg_custom__id FROM isysgui_catg_custom WHERE isysgui_catg_custom__const = {$categoryConstant} LIMIT 1);";

                $insertSql = "INSERT INTO isys_obj_type_2_isysgui_catg_custom_overview 
                    SET isys_obj_type__id = (SELECT isys_obj_type__id FROM isys_obj_type WHERE isys_obj_type__const = {$constant} LIMIT 1),
                    isysgui_catg_custom__id = (SELECT isysgui_catg_custom__id FROM isysgui_catg_custom WHERE isysgui_catg_custom__const = {$categoryConstant} LIMIT 1),
                    isys_obj_type_2_isysgui_catg_custom_overview__sort = {$sort};";

                parent::build(
                    "Create overview page assignment between object type '{$objectTypeConstant}' and global category {$customCategory}.",
                    'C_VALUE_EXISTS',
                    $checkConditionSql,
                    $updateSql,
                    $insertSql
                );
            }
        }
    }
}
