<?php

namespace idoit\Module\Packager\Component\Creator\Xml;

use idoit\Module\Packager\Model\Reports as ReportModel;

/**
 * Class Report
 *
 * @package   idoit\Module\Packager\Component\Creator\Xml
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Report extends Query
{
    /**
     * @param ReportModel $dao
     * @param string      $title
     * @param string      $description
     * @param string      $query
     * @param string      $queryRow
     * @param bool        $isUserSpecific
     * @param string      $querybuilderData
     * @param string      $categoryConstant
     * @param bool        $displayEmptyValues
     * @param bool        $displayRelations
     * @param bool        $isCategoryReport
     * @param string      $constant
     * @param bool        $shouldCompressMultivalueResults
     * @param bool        $shouldShowHtml
     */
    public function appendXml(
        ReportModel $dao,
        string $title,
        string $description,
        string $query,
        string $queryRow,
        bool $isUserSpecific,
        string $querybuilderData,
        string $categoryConstant,
        bool $displayEmptyValues,
        bool $displayRelations,
        bool $isCategoryReport,
        string $constant,
        bool $shouldCompressMultivalueResults,
        bool $shouldShowHtml
    ) {
        // Not supported / necessary:
        // isys_report__mandator
        // isys_report__user

        // Convert the variables so we can use the short string-concatenation form.
        $title = $dao->convert_sql_text($title);
        $description = $dao->convert_sql_text($description);
        $query = $dao->convert_sql_text($query);
        $queryRow = $dao->convert_sql_text($queryRow);
        $userSpecific = $dao->convert_sql_boolean($isUserSpecific);
        $querybuilderData = $dao->convert_sql_text($querybuilderData);
        $emptyValues = $dao->convert_sql_boolean($displayEmptyValues);
        $relations = $dao->convert_sql_boolean($displayRelations);
        $categoryReport = $dao->convert_sql_boolean($isCategoryReport);
        $constant = $dao->convert_sql_text($constant);
        $compressMultivalueResults = $dao->convert_sql_boolean($shouldCompressMultivalueResults);
        $showHtml = $dao->convert_sql_boolean($shouldShowHtml);
        $categoryData = '';

        if (!empty($categoryConstant)) {
            $categoryConstant = $dao->convert_sql_text($categoryConstant);

            $categoryData = "isys_report__isys_report_category__id = (
                SELECT isys_report_category__id
                FROM isys_report_category
                WHERE isys_report_category__const = {$categoryConstant}),";
        }

        $insertSql = "INSERT INTO isys_report SET 
            isys_report__title = {$title}, 
            isys_report__description = {$description}, 
            isys_report__query = {$query}, 
            isys_report__query_row = {$queryRow}, 
            isys_report__datetime = NOW(), 
            isys_report__last_edited = NOW(), 
            isys_report__type = 'c', 
            isys_report__user_specific = {$userSpecific}, 
            isys_report__querybuilder_data = {$querybuilderData}, 
            {$categoryData} 
            isys_report__empty_values = {$emptyValues}, 
            isys_report__display_relations = {$relations}, 
            isys_report__category_report = {$categoryReport}, 
            isys_report__const = {$constant}, 
            isys_report__compressed_multivalue_results = {$compressMultivalueResults},
            isys_report__show_html = {$showHtml};";

        $updateSql = "UPDATE isys_report SET 
            isys_report__title = {$title}, 
            isys_report__description = {$description}, 
            isys_report__query = {$query}, 
            isys_report__query_row = {$queryRow}, 
            isys_report__last_edited = NOW(), 
            isys_report__user_specific = {$userSpecific}, 
            isys_report__querybuilder_data = {$querybuilderData}, 
            {$categoryData}
            isys_report__empty_values = {$emptyValues}, 
            isys_report__display_relations = {$relations}, 
            isys_report__category_report = {$categoryReport}, 
            isys_report__compressed_multivalue_results = {$compressMultivalueResults},
            isys_report__show_html = {$showHtml}
            WHERE isys_report__const = {$constant}
            LIMIT 1;";

        parent::build(
            "Create report {$title}.",
            'C_VALUE_EXISTS',
            "SELECT isys_report__id FROM isys_report WHERE isys_report__const = {$constant} LIMIT 1;",
            $updateSql,
            $insertSql
        );
    }
}
