<?php

namespace idoit\Module\Packager\Model;

use idoit\Model\Dao\Base;
use isys_component_dao_result;
use isys_exception_database;
use RuntimeException;

/**
 * Class ObjectType
 *
 * @package   idoit\Module\Packager\Model
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class ObjectType extends Base
{
    /**
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveForGui(): isys_component_dao_result
    {
        $select = $this->selectImplode([
            'isys_obj_type__id'    => 'id',
            'isys_obj_type__title' => 'title',
            'isys_obj_type__const' => 'constant',
        ]);

        return $this->retrieve("SELECT {$select} FROM isys_obj_type WHERE isys_obj_type__selfdefined = 1;");
    }

    /**
     * @param array $constants
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveByConstants(array $constants): isys_component_dao_result
    {
        if (empty($constants)) {
            throw new RuntimeException('At least one object type constant has to be passed!');
        }

        $select = $this->selectImplode([
            'isys_obj_type_group__const'             => 'groupConstant',
            'isys_obj_type__id'                      => 'id',
            'isys_obj_type__default_template'        => 'defaultTemplate',
            'isys_obj_type__title'                   => 'title',
            'isys_obj_type__description'             => 'description',
            'isys_obj_type__selfdefined'             => 'selfdefined',
            'isys_obj_type__container'               => 'container',
            'isys_obj_type__idoit_obj_type_number'   => 'objTypeNumber',
            'isys_obj_type__obj_img_name'            => 'image',
            'isys_obj_type__icon'                    => 'icon',
            'isys_obj_type__const'                   => 'constant',
            'isys_obj_type__sort'                    => 'sort',
            'isys_obj_type__property'                => 'property',
            'isys_obj_type__status'                  => 'status',
            'isys_obj_type__show_in_tree'            => 'showInTree',
            'isys_obj_type__show_in_rack'            => 'showInRack',
            'isys_obj_type__overview'                => 'overview',
            'isys_obj_type__color'                   => 'color',
            'isys_obj_type__class_name'              => 'className',
            'isys_obj_type__sysid_prefix'            => 'sysidPrefix',
            'isys_obj_type__relation_master'         => 'relationMaster',
            'isys_obj_type__use_template_title'      => 'useTemplateTitle',
        ]);

        $constantList = implode(', ', array_map(function ($constant) { return $this->convert_sql_text($constant); }, $constants));

        $sql = "SELECT {$select}, isysgui_cats__const AS specificCategory
            FROM isys_obj_type 
            LEFT JOIN isys_obj_type_group ON isys_obj_type_group__id = isys_obj_type__isys_obj_type_group__id
            LEFT JOIN isysgui_cats ON isysgui_cats__id = isys_obj_type__isysgui_cats__id
            WHERE isys_obj_type__const IN ({$constantList});";

        return $this->retrieve($sql);
    }

    /**
     * @param int $id
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveGlobalCategoriesByObjectType(int $id): isys_component_dao_result
    {
        $objectTypeId = $this->convert_sql_id($id);

        $sql = "SELECT isysgui_catg__const AS constant
            FROM isys_obj_type_2_isysgui_catg 
            INNER JOIN isysgui_catg ON isysgui_catg__id = isys_obj_type_2_isysgui_catg__isysgui_catg__id 
            WHERE isys_obj_type_2_isysgui_catg__isys_obj_type__id = {$objectTypeId};";

        return $this->retrieve($sql);
    }

    /**
     * @param int $id
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveCustomCategoriesByObjectType(int $id): isys_component_dao_result
    {
        $objectTypeId = $this->convert_sql_id($id);

        $sql = "SELECT isysgui_catg_custom__const AS constant
            FROM isys_obj_type_2_isysgui_catg_custom 
            INNER JOIN isysgui_catg_custom ON isysgui_catg_custom__id = isys_obj_type_2_isysgui_catg_custom__isysgui_catg_custom__id 
            WHERE isys_obj_type_2_isysgui_catg_custom__isys_obj_type__id = {$objectTypeId};";

        return $this->retrieve($sql);
    }

    /**
     * @param int $id
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveGlobalOverviewPageAssignments(int $id): isys_component_dao_result
    {
        $objectTypeId = $this->convert_sql_id($id);

        $sql = "SELECT b.isysgui_catg__const AS constant
            FROM isys_obj_type_2_isysgui_catg_overview AS a
            INNER JOIN isysgui_catg AS b ON b.isysgui_catg__id = a.isysgui_catg__id
            WHERE a.isys_obj_type__id = {$objectTypeId}
            ORDER BY a.isys_obj_type_2_isysgui_catg_overview__sort ASC;";

        return $this->retrieve($sql);
    }

    /**
     * @param int $id
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveCustomOverviewPageAssignments(int $id): isys_component_dao_result
    {
        $objectTypeId = $this->convert_sql_id($id);

        $sql = "SELECT b.isysgui_catg_custom__const AS constant
            FROM isys_obj_type_2_isysgui_catg_custom_overview AS a
            INNER JOIN isysgui_catg_custom AS b ON b.isysgui_catg_custom__id = a.isysgui_catg_custom__id
            WHERE a.isys_obj_type__id = {$objectTypeId}
            ORDER BY a.isys_obj_type_2_isysgui_catg_custom_overview__sort ASC;";

        return $this->retrieve($sql);
    }
}
