<?php

namespace idoit\Module\UpperCaseIdentifier\Processor;

use idoit\Module\UpperCaseIdentifier\Processor;
use isys_cmdb_dao;
use isys_format_json;

/**
 * Class Deactivate
 *
 * @package   idoit\Module\UpperCaseIdentifier\Processor
 * @copyright <manufacturer>
 * @license   <website>
 */
class Deactivate extends Processor
{
    /**
     * @return mixed|void
     * @throws \idoit\Exception\JsonException
     * @throws \isys_exception_dao
     */
    public function process()
    {
        $objectTypeGroups = $this->getDataFileContent('object-type-groups.json');

        if (\count($objectTypeGroups)) {
            $this->deactivateObjectTypeGroups($objectTypeGroups);
        }

        // Set custom categories to status normal when activating the add-on.
        $customCategories = $this->getDataFileContent('custom-categories.json');

        if (\count($customCategories)) {
            $this->deactivateCustomCategories($customCategories);
        }
    }

    /**
     * @param array $objectTypeGroups
     *
     * @throws \isys_exception_dao
     */
    private function deactivateObjectTypeGroups(array $objectTypeGroups)
    {
        $dao = isys_cmdb_dao::instance($this->database);
        $statusArchive = $dao->convert_sql_int(C__RECORD_STATUS__ARCHIVED);

        $objectTypeGroupConstants = implode(', ', array_filter(array_unique(array_map(function ($objectTypeGroup) use ($dao) {
            return $dao->convert_sql_text($objectTypeGroup['constant']);
        }, $objectTypeGroups))));

        $dao->update("UPDATE isys_obj_type_group SET isys_obj_type_group__status = {$statusArchive} WHERE isys_obj_type_group__const IN ({$objectTypeGroupConstants});");
        $dao->apply_update();
    }

    /**
     * @param array $customCategories
     *
     * @throws \isys_exception_dao
     */
    private function deactivateCustomCategories(array $customCategories)
    {
        $dao = isys_cmdb_dao::instance($this->database);
        $statusArchive = $dao->convert_sql_int(C__RECORD_STATUS__ARCHIVED);

        $customCategoryConstants = implode(', ', array_filter(array_unique(array_map(function ($constant) use ($dao) {
            return $dao->convert_sql_text($constant);
        }, $customCategories))));

        $dao->update("UPDATE isysgui_catg_custom SET isysgui_catg_custom__status = {$statusArchive} WHERE isysgui_catg_custom__const IN ({$customCategoryConstants});");
        $dao->apply_update();
    }
}
