/**
 * i-doit object radius editor javascript class.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
window.DataSelector = Class.create({
    options: {},

    initialize: function ($el, selection, options) {
        this.$element = $el;
        this.data = [];
        this.selection = selection || [];
        this.options = {
            $resultContainer: null,
            callback: 'loadObjectTypeGroups',
            editMode: false,
            onChange: Prototype.emptyFunction
        };

        Object.extend(this.options, options || {});

        if (Object.isElement(this.options.$resultContainer)) {
            this.options.$resultContainer.setValue(JSON.stringify(this.selection));
        }

        this.prepareGui();
        this.prepareObserver();
        this.retrieveData();
    },

    prepareGui: function () {
        this.$filter = new Element('input', {className:'input input-block', placeholder: idoit.Translate.get('LC__MODULE__PACKAGER__FILTER')});
        this.$listContainer = new Element('div', {className: 'border mt5'});
        this.$selectedList = new Element('ul', {className:'list-style-none m0'});
        this.$unselectedList = new Element('ul', {className:'list-style-none m0 unselected-list'});

        this.$element
            .update(this.$filter)
            .insert(this.$listContainer
                .update(new Element('div', {className: 'bg-neutral-200 p10 border-bottom'})
                    .update(idoit.Translate.get('LC__MODULE__PACKAGER__SELECTED')))
                .insert(this.$selectedList)
                .insert(new Element('div', {className: 'bg-neutral-200 p10 border-top border-bottom'})
                    .update(idoit.Translate.get('LC__MODULE__PACKAGER__AVAILABLE')))
                .insert(this.$unselectedList)
            );
    },

    prepareObserver: function () {
        var self = this;

        this.$element.on('click', 'button', function (ev) {
            var $button = ev.findElement('button'),
                constant = $button.up('li').readAttribute('data-constant');

            if ($button.readAttribute('data-action') === 'add') {
                self.selection.push(constant);
            } else {
                self.selection = self.selection.without(constant);
            }

            self.options.onChange(self.selection);

            if (Object.isElement(self.options.$resultContainer)) {
                self.options.$resultContainer.setValue(JSON.stringify(self.selection));
            }

            self.process();
        });

        this.$filter.on('keyup', function () {
            var term = self.$filter.getValue().toLowerCase().trim(),
                $selected = self.$selectedList.select('li'),
                $unselected = self.$unselectedList.select('li');

            delay(function () {
                $selected.invoke('removeClassName', 'hide');
                $unselected.invoke('removeClassName', 'hide');

                if (term.blank()) {
                    return;
                }

                $selected
                    .filter(function($item) {
                        return !$item.down('span').innerText.toLowerCase().include(term);
                    })
                    .invoke('addClassName', 'hide');
                $unselected
                    .filter(function($item) {
                        return !$item.down('span').innerText.toLowerCase().include(term);
                    })
                    .invoke('addClassName', 'hide');

            }, 500, 'packager.' + self.options.callback);
        });
    },

    retrieveData: function () {
        var self = this;

        this.$selectedList
            .update(new Element('li')
                .update(new Element('span')
                    .update(new Element('img', {src: window.dir_images + 'axialis/user-interface/loading.svg', className: 'vam mr5 animation-rotate'}))
                    .insert(idoit.Translate.get('LC__UNIVERSAL__LOADING'))));
        this.$unselectedList
            .update(new Element('li')
                .update(new Element('span')
                    .update(new Element('img', {src: window.dir_images + 'axialis/user-interface/loading.svg', className: 'vam mr5 animation-rotate'}))
                    .insert(idoit.Translate.get('LC__UNIVERSAL__LOADING'))));

        new Ajax.Request(window.www_dir + 'packager/ajax/loadData', {
            parameters: {
                callback: this.options.callback
            },
            onComplete: function (xhr) {
                try {
                    if (!is_json_response(xhr)) {
                        throw 'Could not retrieve data for callback "' + self.options.callback + '".';
                    }

                    var json = xhr.responseJSON;

                    if (!json.success) {
                        throw 'The callback "' + self.options.callback + '" did not finish successfully.';
                    }

                    self.data = json.data;

                    self.process();
                } catch (e) {
                    idoit.Notify.error(e, {sticky: true});
                }
            }
        });
    },

    process: function () {
        var term = this.$filter.getValue().toLowerCase().trim(),
            hidden, i;

        this.$selectedList.update();
        this.$unselectedList.update();

        for (i in this.data) {
            if (!this.data.hasOwnProperty(i)) {
                continue;
            }

            hidden = !this.data[i].title.toLowerCase().include(term);

            if (this.selection.indexOf(this.data[i].constant) !== -1) {
                // The item has been selected, render accordingly.
                this.renderSelectedItem(this.data[i], hidden);
            } else {
                // The item has been selected, render accordingly.
                this.renderUnselectedItem(this.data[i], hidden);
            }
        }

        $('body').fire('update:tooltips');
    },

    renderSelectedItem: function (item, hidden) {
        var $actionButton = null;

        if (this.options.editMode) {
            $actionButton = new Element('button', {type: 'button', className: 'btn btn-small', 'data-action': 'delete', title: idoit.Translate.get('LC__UNIVERSAL__REMOVE'), 'data-tooltip': 1})
                .update(new Element('img', {src: window.dir_images + 'axialis/basic/symbol-cancel.svg'}));
        }

        this.$selectedList
            .insert(new Element('li', {'data-constant': item.constant, className: (hidden ? 'hide' : '')})
                .update(new Element('span').update(item.title))
                .insert($actionButton));
    },

    renderUnselectedItem: function (item, hidden) {
        var $actionButton = null;

        if (!item.hasOwnProperty('constant') || item.constant === null) {
            item.constant = '';
        }

        if (this.options.editMode) {
            $actionButton = new Element('button', {type: 'button', className: 'btn btn-small', 'data-action': 'add', title: idoit.Translate.get('LC__UNIVERSAL__ADD'), 'data-tooltip': 1})
                .update(new Element('img', {src: window.dir_images + 'axialis/basic/symbol-add.svg'}));

            if (item.constant.blank()) {
                $actionButton = new Element('button', {type: 'button', className: 'btn btn-small', disabled: 'disabled', title: idoit.Translate.get('LC__MODULE__PACKAGER__SELECTION_ERROR'), 'data-tooltip': 1})
                    .update(new Element('img', {src: window.dir_images + 'axialis/construction/warning-sign.svg'}));
            }
        }

        this.$unselectedList
            .insert(new Element('li', {'data-constant': item.constant, className: (hidden ? 'hide' : '')})
                .update(new Element('span').update(item.title))
                .insert($actionButton));
    }
});
