<?php

namespace idoit\Module\Packager\Component\Creator;

use idoit\Module\Packager\Model\FileRepository as FileRepositoryModel;

/**
 * Class CustomFile
 *
 * @package   idoit\Module\Packager\Component\Creator
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class CustomFile
{
    /**
     * @var string
     */
    private $addonPath;

    /**
     * @var FileRepositoryModel
     */
    private $fileRepositoryModel;

    /**
     * CustomFile constructor.
     *
     * @param string              $addonPath
     * @param FileRepositoryModel $fileRepositoryModel
     */
    public function __construct(string $addonPath, FileRepositoryModel $fileRepositoryModel)
    {
        $this->addonPath = $addonPath;
        $this->fileRepositoryModel = $fileRepositoryModel;
    }

    /**
     * Method for creating our three basic static add-on files.
     *
     * @param int $repositoryId
     *
     * @throws \isys_exception_database
     */
    public function createDirectoriesAndFiles(int $repositoryId)
    {
        $directoryCreator = new Directory($this->addonPath);

        $result = $this->fileRepositoryModel->retrieveByRepositoryId($repositoryId);

        while ($row = $result->get_row()) {
            // The path should ALWAYS be relative and start with "./" - navigation to parent folders (for example via "../") is not allowed.
            $relativePath = \dirname(preg_replace('~^\.\/~', '', $row['title']));
            $fullPath = $this->addonPath . $relativePath . '/' . \basename($row['title']);

            $directoryCreator->createDirectories((array)$relativePath);

            file_put_contents($fullPath, $row['content']);
        }
    }
}
