<?php

namespace idoit\Module\Packager\Component\Creator;

use isys_format_json as JSON;

/**
 * Class DataFile
 *
 * @package   idoit\Module\Packager\Component\Creator
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class DataFile
{
    /**
     * @var string
     */
    private $addonDataPath;

    /**
     * DataFile constructor.
     *
     * @param string $addonPath
     */
    public function __construct(string $addonPath)
    {
        $this->addonDataPath = $addonPath . 'data/';
    }

    /**
     * Method for creating our three basic static add-on files.
     *
     * @param string $dialogData
     * @param array  $objectTypeGroups
     * @param array  $objectTypeAssignments
     * @param array  $customCategories
     * @param array  $reports
     */
    public function createDataFiles(string $dialogData, array $objectTypeGroups, array $objectTypeAssignments, array $customCategories, array $reports, array $uninstallConfiguration)
    {
        isys_file_put_contents($this->addonDataPath . 'dialog-plus.json', $dialogData);
        isys_file_put_contents($this->addonDataPath . 'object-type-groups.json', JSON::encode($objectTypeGroups));
        isys_file_put_contents($this->addonDataPath . 'object-type-assignments.json', JSON::encode($objectTypeAssignments));
        isys_file_put_contents($this->addonDataPath . 'custom-categories.json', JSON::encode($customCategories));
        isys_file_put_contents($this->addonDataPath . 'reports.json', JSON::encode($reports));
        // @see PACKAGER-39 Create a new file with info about which data should be removed on uninstall.
        isys_file_put_contents($this->addonDataPath . 'uninstall-configuration.json', JSON::encode($uninstallConfiguration));
    }
}
