<?php

namespace idoit\Module\Packager\Component\Creator\Xml;

use SimpleXMLElement;

/**
 * Class Query
 *
 * @package   idoit\Module\Packager\Component\Creator\Xml
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
abstract class Query
{
    /**
     * @var SimpleXMLElement
     */
    private $rootElement;

    /**
     * Query constructor.
     *
     * @param SimpleXMLElement $rootElement
     */
    public function __construct(SimpleXMLElement $rootElement)
    {
        $this->rootElement = $rootElement;
    }

    /**
     * @param string $title
     * @param string $checkParameter
     * @param string $checkCondition
     * @param string $onSuccess
     * @param string $onFailure
     *
     * @return void
     */
    public function build(string $title, string $checkParameter, string $checkCondition, string $onSuccess, string $onFailure)
    {
        // Create a new "query" element.
        $query = $this->rootElement->addChild('query');

        // Add the "title" element.
        $query->addChild('title', $title);

        // Add the "check" element, this will contain the check parameter and check condition.
        $query->addChild('check', $checkCondition)->addAttribute('ident', $checkParameter);

        // Create the actual SQL query elements.
        $sqlNode = $query->addChild('sql');
        $sqlNode->addChild('exec', str_replace('&', '&amp;', $onSuccess))->addAttribute('ident', 'true');
        $sqlNode->addChild('exec', str_replace('&', '&amp;', $onFailure))->addAttribute('ident', 'false');
    }
}
