<?php /** @noinspection MagicMethodsValidityInspection */

namespace idoit\Module\Packager\Configuration;

use DateTime;

/**
 * Class Addon
 *
 * @property-read string   $identifier
 * @property-read string   $title
 * @property-read string   $description
 * @property-read string   $version
 * @property-read string   $manufacturer
 * @property-read string   $website
 * @property-read bool     $requiresLicense
 * @property-read string   $idoitVersionRequirement
 * @property-read DateTime $createdDate
 * @property-read DateTime $updatedDate
 * @property-read DateTime $releaseDate
 * @property-read string   $changelog
 * @property-read bool     $uninstallObjectTypeGroups
 * @property-read array    $assignedObjectTypeGroups
 * @property-read bool     $uninstallObjectTypes
 * @property-read array    $assignedObjectTypes
 * @property-read bool     $uninstallCustomCategories
 * @property-read array    $assignedCustomCategories
 * @property-read array    $selectedReports
 * @property-read string   $dialogPlusData
 * @property-read array    $selectedRelationTypes
 * @property-read array    $selectedCsvImportProfiles
 *
 * @package   idoit\Module\Packager\Configuration
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Addon
{
    /** @var string */
    private string $identifier;

    /** @var string */
    private string $title;

    /** @var string */
    private string $description;

    /** @var string */
    private string $version;

    /** @var string */
    private string $manufacturer;

    /** @var string */
    private string $website;

    /** @var bool */
    private bool $requiresLicense;

    /** @var string */
    private string $idoitVersionRequirement;

    /** @var DateTime */
    private DateTime $createdDate;

    /** @var DateTime */
    private DateTime $updatedDate;

    /** @var DateTime */
    private DateTime $releaseDate;

    /** @var string */
    private string $changelog;

    /** @var bool */
    private bool $uninstallObjectTypeGroups;

    /** @var array */
    private array $assignedObjectTypeGroups = [];

    /** @var bool */
    private bool $uninstallObjectTypes;

    /**  @var array */
    private array $assignedObjectTypes = [];

    /** @var bool */
    private bool $uninstallCustomCategories;

    /** @var array */
    private array $assignedCustomCategories = [];

    /** @var array */
    private array $selectedReports = [];

    /** @var string */
    private string $dialogPlusData;

    /** @var array */
    private array $selectedRelationTypes = [];

    /** @var array */
    private array $selectedCsvImportProfiles = [];

    /**
     * Addon constructor.
     *
     * @param string   $identifier
     * @param string   $title
     * @param string   $description
     * @param string   $version
     * @param string   $manufacturer
     * @param string   $website
     * @param bool     $requiresLicense
     * @param string   $idoitVersionRequirement
     * @param DateTime $createdDate
     * @param DateTime $updatedDate
     * @param DateTime $releaseDate
     * @param string   $changelog
     * @param array    $assignedObjectTypeGroups
     * @param bool     $uninstallObjectTypeGroups
     * @param array    $assignedObjectTypes
     * @param bool     $uninstallObjectTypes
     * @param array    $assignedCustomCategories
     * @param bool     $uninstallCustomCategories
     * @param array    $selectedReports
     * @param string   $dialogPlusData
     * @param array    $selectedRelationTypes
     * @param array    $selectedCsvImportProfiles
     */
    public function __construct(
        string $identifier,
        string $title,
        string $description,
        string $version,
        string $manufacturer,
        string $website,
        bool $requiresLicense,
        string $idoitVersionRequirement,
        DateTime $createdDate,
        DateTime $updatedDate,
        DateTime $releaseDate,
        string $changelog,
        array $assignedObjectTypeGroups,
        bool $uninstallObjectTypeGroups,
        array $assignedObjectTypes,
        bool $uninstallObjectTypes,
        array $assignedCustomCategories,
        bool $uninstallCustomCategories,
        array $selectedReports,
        string $dialogPlusData,
        array $selectedRelationTypes,
        array $selectedCsvImportProfiles
    ) {
        $this->identifier = $identifier;
        $this->title = $title;
        $this->description = $description;
        $this->version = $version;
        $this->manufacturer = $manufacturer;
        $this->website = $website;
        $this->requiresLicense = $requiresLicense;
        $this->idoitVersionRequirement = $idoitVersionRequirement;
        $this->createdDate = $createdDate;
        $this->updatedDate = $updatedDate;
        $this->releaseDate = $releaseDate;
        $this->changelog = $changelog;
        $this->uninstallObjectTypeGroups = $uninstallObjectTypeGroups;
        $this->assignedObjectTypeGroups = $assignedObjectTypeGroups;
        $this->uninstallObjectTypes = $uninstallObjectTypes;
        $this->assignedObjectTypes = $assignedObjectTypes;
        $this->uninstallCustomCategories = $uninstallCustomCategories;
        $this->assignedCustomCategories = $assignedCustomCategories;
        $this->selectedReports = $selectedReports;
        $this->dialogPlusData = $dialogPlusData;
        $this->selectedRelationTypes = $selectedRelationTypes;
        $this->selectedCsvImportProfiles = $selectedCsvImportProfiles;
    }

    /**
     * Retrieves a property of this class.
     *
     * @param string $name
     *
     * @return mixed
     */
    public function __get(string $name)
    {
        if (property_exists($this, $name)) {
            return $this->$name;
        }

        return null;
    }

    /**
     * This method is necessary for calls like `empty($config->assignedObjectTypeGroups)`.
     *
     * @param string $name
     *
     * @return bool
     */
    public function __isset($name)
    {
        return property_exists($this, $name);
    }
}
