<?php

namespace idoit\Module\Packager\Model;

use idoit\Model\Dao\Base;
use isys_component_dao_result;

/**
 * Class Addon
 *
 * @package   idoit\Module\Packager\Model
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Addon extends Base
{
    const FIELDS = [
        'isys_packager__id'                           => 'id',
        'isys_packager__title'                        => 'title',
        'isys_packager__identifier'                   => 'identifier',
        'isys_packager__manufacturer'                 => 'manufacturer',
        'isys_packager__website'                      => 'website',
        'isys_packager__requires_license'             => 'requiresLicense',
        'isys_packager__idoit_requirement'            => 'idoitRequirement',
        'isys_packager__include_definition'           => 'includeDefinition',
        'isys_packager__created'                      => 'created',
        'isys_packager__updated'                      => 'updated',
        'isys_packager__description'                  => 'description',
        'isys_packager__status'                       => 'status',
        'isys_packager__uninstall_object_type_groups' => 'uninstallObjectTypeGroups',
        'isys_packager__object_type_groups'           => 'assignedObjectTypeGroups',
        'isys_packager__uninstall_object_types'       => 'uninstallObjectTypes',
        'isys_packager__object_types'                 => 'assignedObjectTypes',
        'isys_packager__uninstall_custom_categories'  => 'uninstallCustomCategories',
        'isys_packager__custom_categories'            => 'assignedCustomCategories',
        'isys_packager__reports'                      => 'selectedReports',
        'isys_packager__dialog_plus'                  => 'selectedDialogPlus',
        'isys_packager__relation_types'               => 'selectedRelationTypes',
        'isys_packager__csv_import_profiles'          => 'selectedCsvImportProfiles',
    ];

    /**
     * @param int $id
     *
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getById(int $id): isys_component_dao_result
    {
        $selects = $this->selectImplode(self::FIELDS);

        return $this->retrieve("SELECT {$selects} FROM isys_packager WHERE isys_packager__id = {$id};");
    }

    /**
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getAddonList(): isys_component_dao_result
    {
        $selects = $this->selectImplode(self::FIELDS);

        $sql = "SELECT {$selects} FROM isys_packager ORDER BY isys_packager__id;";

        return $this->retrieve($sql);
    }

    /**
     * @param int|null $id
     * @param array    $data
     *
     * @return int
     * @throws \isys_exception_dao
     */
    public function saveAddon(?int $id = null, array $data = []): int
    {
        $fieldValues = [];
        $fieldKeys = array_flip(self::FIELDS);

        foreach ($data as $key => $value) {
            if (!isset($fieldKeys[$key])) {
                continue;
            }

            switch ($key) {
                default:
                    $value = $this->convert_sql_text($value);
                    break;

                case 'updated':
                case 'created':
                    $value = $this->convert_sql_datetime($value);
                    break;

                case 'status':
                    $value = $this->convert_sql_int($value);
                    break;

                case 'uninstasllObjectTypeGroups':
                case 'uninstasllObjectTypes':
                case 'uninstallCustomCategories':
                    $value = $this->convert_sql_boolean($value);
                    break;
            }

            $fieldValues[] = $fieldKeys[$key] . ' = ' . $value;
        }

        $values = implode(', ', $fieldValues);

        if ($id === null) {
            // Create context.
            $this->update("INSERT INTO isys_packager SET {$values};");

            // Get the last created ID.
            $id = $this->get_last_insert_id();
        } else {
            // Update context.
            $this->update("UPDATE isys_packager SET {$values} WHERE isys_packager__id = {$id};");
        }

        return $id;
    }

    /**
     * @param int|array $ids
     *
     * @return bool
     * @throws \isys_exception_dao
     */
    public function deleteAddon($ids): bool
    {
        $idCondition = $this->prepare_in_condition((array)$ids);

        return $this->update("DELETE FROM isys_packager WHERE isys_packager__id {$idCondition};") && $this->apply_update();
    }

    /**
     * Sanitize the given identifier: lowercase, only [a-z0-9_] but no underscore at beginning or end.
     *
     * @param string $identifier
     *
     * @return string
     */
    public static function sanitizeIdentifier(string $identifier): string
    {
        // If no identifier was provided, we use a hash.
        if (empty($identifier)) {
            $identifier = md5(microtime(true));
        }

        // Make the identifier lower case.
        $identifier = strtolower($identifier);

        // Clean the identifier from unwanted input.
        $identifier = (string) preg_replace(['~[^a-z0-9_]~', '~^[_]*~', '~[_]*$~'], ['', '', ''], $identifier);

        // Only allow the identifier to be 32 characters long.
        return substr($identifier, 0, 32);
    }
}
