<?php

namespace idoit\Module\Packager\Model;

use idoit\Model\Dao\Base;
use isys_component_dao_result;
use isys_dialog_admin_dao;
use isys_exception_database;
use RuntimeException;

/**
 * Class DialogPlus
 *
 * @package   idoit\Module\Packager\Model
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class DialogPlus extends Base
{
    /**
     * @return array
     * @throws isys_exception_database
     */
    public function retrieveForGui(): array
    {
        $result = [];
        $dao = isys_dialog_admin_dao::instance($this->m_db);
        $dialogTables = $dao->get_dialog_tables(true);

        foreach ($dialogTables as $dialogTable) {
            $result[] = [
                'title'    => $dialogTable,
                'constant' => $dialogTable
            ];
        }

        $customTables = $dao->get_custom_dialogs();

        foreach ($customTables as $customTable) {
            $result[] = [
                'title' => $customTable['categoryTitle'] . ' > ' . $customTable['fieldTitle'],
                'constant' => 'isys_dialog_plus_custom:' . $customTable['identifier']
            ];
        }

        return $result;
    }

    /**
     * @param string $table
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function retrieveByTableName(string $table): isys_component_dao_result
    {
        if (empty($table)) {
            throw new RuntimeException('A table name has to be passed!');
        }

        $condition = '';

        if (strpos($table, 'isys_dialog_plus_custom:') === 0) {
            // Custom category dialog-plus.
            list($table, $identifier) = explode(':', $table);
            $condition = 'WHERE isys_dialog_plus_custom__identifier = ' . $this->convert_sql_text($identifier);
        }

        // Check for "parent" fields.
        $parentField = $this->retrieve("SHOW COLUMNS FROM {$table} WHERE FIELD LIKE '{$table}__isys_%';")->get_row_value('Field');

        $sortFieldExists = \isys_cmdb_dao::instance($this->m_db)->fieldsExistsInTable($table, [$table . '__sort']);

        // @todo  PACKAGER-33  The 'isys_dialog_plus_custom' condition is only a temporary hotfix!
        if ($parentField && $table !== 'isys_dialog_plus_custom') {
            // We have to trust the i-doit database naming convention here.
            $referenceTable = str_replace([$table . '__', '__id'], '', $parentField);

            $selectFieldsArray = [
                $table . '__title'          => 'title',
                $table . '__const'          => 'constant',
                $referenceTable . '__title' => $referenceTable
            ];
            if ($sortFieldExists) {
                $selectFieldsArray[$table . '__sort'] = 'sort';
            }
            $select = $this->selectImplode($selectFieldsArray);

            $orderBy = $sortFieldExists ? 'ORDER BY ' . $table . '__sort ASC' : '';
            $sql = "SELECT {$select} 
                FROM {$table} 
                LEFT JOIN {$referenceTable} ON {$referenceTable}__id = {$parentField}
                {$condition} 
                {$orderBy} 
                LIMIT 10000;";
        } else {
            $selectFieldsArray = [
                $table . '__title' => 'title',
                $table . '__const' => 'constant',
            ];
            if ($sortFieldExists) {
                $selectFieldsArray[$table . '__sort'] = 'sort';
            }
            $select = $this->selectImplode($selectFieldsArray);

            $orderBy = $sortFieldExists ? 'ORDER BY ' . $table . '__sort ASC' : '';
            $sql = "SELECT {$select} 
                FROM {$table} 
                {$condition} 
                {$orderBy} 
                LIMIT 10000;";
        }

        return $this->retrieve($sql);
    }
}
