<?php

namespace idoit\Module\Packager\Model;

use Exception;
use idoit\Model\Dao\Base;
use isys_application;
use isys_component_dao_result;

/**
 * Class File
 *
 * @package   idoit\Module\Packager\Model
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class File extends Base
{
    const FIELDS = [
        'isys_packager_file__id'                => 'id',
        'isys_packager_file__isys_packager__id' => 'addonId',
        'isys_packager_file__title'             => 'title',
        'isys_packager_file__type'              => 'type',
        'isys_packager_file__content'           => 'content',
        'isys_packager_file__created'           => 'created',
        'isys_packager_file__updated'           => 'updated',
        'isys_packager_file__description'       => 'description',
        'isys_packager_file__status'            => 'status'
    ];

    const TYPE_TRANSLATION = 'translation';
    const TYPE_IMPORT_CSV  = 'importCsv';
    const TYPE_IMPORT_XML  = 'importXml';
    const TYPE_CUSTOM      = 'custom';

    /**
     * @param string $type
     *
     * @return string
     * @throws Exception
     */
    public static function getTranslatedType(string $type): string
    {
        $typeMapping = [
            self::TYPE_TRANSLATION => 'LC__MODULE__PACKAGER__FILE__TYPE_TRANSLATION',
            self::TYPE_IMPORT_CSV  => 'LC__MODULE__PACKAGER__FILE__TYPE_IMPORT_CSV',
            self::TYPE_IMPORT_XML  => 'LC__MODULE__PACKAGER__FILE__TYPE_IMPORT_XML',
            self::TYPE_CUSTOM      => 'LC__MODULE__PACKAGER__FILE__TYPE_CUSTOM',
        ];

        if (!isset($typeMapping[$type])) {
            throw new Exception('The type "' . $type . '" does not exist.');
        }

        $language = isys_application::instance()->container->get('language');

        return $language->get($typeMapping[$type]);
    }

    public static function getPathByType(string $type): string
    {
        $typeMapping = [
            self::TYPE_TRANSLATION => './lang/',
            self::TYPE_IMPORT_CSV  => './data/csv/',
            self::TYPE_IMPORT_XML  => './data/xml/',
            self::TYPE_CUSTOM      => '',
        ];

        if (!isset($typeMapping[$type])) {
            throw new Exception('The type "' . $type . '" does not exist.');
        }

        return $typeMapping[$type];
    }

    /**
     * @param int $addonId
     *
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getFileList(int $addonId): isys_component_dao_result
    {
        $sql = "SELECT
            isys_packager_file__id AS id,
            isys_packager_file__title AS title,
            isys_packager_file__type AS type,
            isys_packager_file__description AS description
            FROM isys_packager_file
            WHERE isys_packager_file__isys_packager__id = {$addonId};";

        return $this->retrieve($sql);
    }

    /**
     * @param int|null $id
     * @param array    $data
     *
     * @return int
     * @throws \isys_exception_dao
     */
    public function saveFile(?int $id = null, array $data = []): int
    {
        $fieldValues = [];
        $fieldKeys = array_flip(self::FIELDS);

        foreach ($data as $key => $value) {
            if (!isset($fieldKeys[$key])) {
                continue;
            }

            switch ($key) {
                default:
                    $value = $this->convert_sql_text($value);
                    break;

                case 'addonId':
                    $value = $this->convert_sql_id($value);
                    break;

                case 'updated':
                case 'created':
                    $value = $this->convert_sql_datetime($value);
                    break;

                case 'status':
                    $value = $this->convert_sql_int($value);
                    break;
            }

            $fieldValues[] = $fieldKeys[$key] . ' = ' . $value;
        }

        $values = implode(', ', $fieldValues);

        if ($id === null) {
            // Create context.
            $this->update("INSERT INTO isys_packager_file SET {$values};");

            // Get the last created ID.
            $id = $this->get_last_insert_id();
        } else {
            // Update context.
            $this->update("UPDATE isys_packager_file SET {$values} WHERE isys_packager_file__id = {$id};");
        }

        return $id;
    }

    /**
     * @param int|array $ids
     *
     * @return bool
     * @throws \isys_exception_dao
     */
    public function deleteFile($ids): bool
    {
        $idCondition = $this->prepare_in_condition((array)$ids);

        return $this->update("DELETE FROM isys_packager_file WHERE isys_packager_file__id {$idCondition};") && $this->apply_update();
    }
}
