<?php

namespace idoit\Module\Packager\View;

use Exception;
use idoit\Model\Dao\Base as DaoBase;
use idoit\Module\Packager\Model\Repository as RepositoryModel;
use idoit\View\Base;
use isys_application;
use isys_application as Application;
use isys_component_list as ComponentList;
use isys_component_template as ComponentTemplate;
use isys_module as ModuleBase;
use isys_module_packager;

/**
 * Class RepositoryList
 *
 * @package   idoit\Module\Packager\View
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class RepositoryList extends Base
{
    /**
     * @param ModuleBase        $module
     * @param ComponentTemplate $template
     * @param DaoBase           $model
     *
     * @return $this
     */
    public function process(ModuleBase $module, ComponentTemplate $template, DaoBase $model)
    {
        // Set paths to templates.
        $this->paths['contentbottomcontent'] = $module::getPath() . 'templates/main.tpl';

        $repositoryModel = RepositoryModel::instance(Application::instance()->container->get('database'));

        // Get list component.
        $listComponent = new ComponentList();
        $listComponent->set_row_modifier($this, 'rowModifier');
        $listComponent->config([
            'id'         => 'LC__MODULE__PACKAGER__ID',
            'title'      => 'LC__MODULE__PACKAGER__TITLE',
            'version'    => 'LC__MODULE__PACKAGER__VERSION',
            'identifier' => 'LC__MODULE__PACKAGER__ADD_ON_IDENTIFIER',
            'created'    => 'LC__MODULE__PACKAGER__RELEASE_DATE',
        ], \isys_core::request_url() . 'packager/repository/[{id}]', '[{id}]');

        $template
            ->assign('tableComponent', $listComponent->getTempTableHtml($repositoryModel->getRepositoryList((int)$this->id)))
            ->smarty_tom_add_rule('tom.content.bottom.buttons.*.p_bInvisible=1')
            ->smarty_tom_add_rule('tom.content.navbar.cRecStatus.p_bInvisible=1');

        return $this;
    }

    /**
     * @param array &$row
     *
     * @throws \isys_exception_locale
     */
    public function rowModifier(&$row)
    {
        try {
            $locale = isys_application::instance()->container->get('locales');

            $row['created'] = $locale->fmt_datetime($row['created']);
        } catch (Exception $e) {

        }
    }
}
