<div id="add-on-packager">
    <div id="add-on-packager-configuration">
        <fieldset class="overview">
            <legend class="border-top-none">[{isys type='lang' ident='LC__MODULE__PACKAGER__BASIC_INFORMATION'}]</legend>

            <table class="contentTable">
                <tr>
                    <td class="key">[{isys type='f_label' name='title' ident='LC__MODULE__PACKAGER__TITLE'}]</td>
                    <td class="value">[{isys type='f_text' name='title'}]</td>
                </tr>
                <tr>
                    <td class="key">[{isys type='f_label' name='manufacturer' ident='LC__MODULE__PACKAGER__MANUFACTURER' mandatory=true}]</td>
                    <td class="value">[{isys type='f_text' name='manufacturer'}]</td>
                </tr>
                <tr>
                    <td class="key">[{isys type='f_label' name='website' ident='LC__MODULE__PACKAGER__WEBSITE'}]</td>
                    <td class="value">[{isys type='f_text' name='website'}]</td>
                </tr>
                <tr>
                    <td class="key">[{isys type='f_label' name='requiresLicense' ident='LC__MODULE__PACKAGER__REQUIRES_LICENSE'}]</td>
                    <td class="value">[{isys type='f_dialog' name='requiresLicense'}]</td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type='f_label' name='identifier' ident='LC__MODULE__PACKAGER__ADD_ON_IDENTIFIER' mandatory=true}]</td>
                    <td class="value">
                        [{if $identifier}]
                            <div class="ml20 input-group input-size-normal text-normal mouse-default">
                                <div class="input">[{$identifier}]</div>
                            </div>
                        [{else}]
                            [{isys type='f_text' name='identifier'}]
                        [{/if}]
                        <br class="cb" />
                        <div class="ml20 mt5 input-size-normal">
                            <p class="p5 box-blue">
                                <img src="[{$dir_images}]axialis/basic/button-info.svg" alt="" class="vam mr5" />
                                <span class="vam">[{isys type='lang' ident='LC__MODULE__PACKAGER__ADD_ON_IDENTIFIER_DESCRIPTION'}]</span>
                            </p>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <hr class="mt5 mb5" />
                    </td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type='f_label' name='idoitRequirement' ident='LC__MODULE__PACKAGER__IDOIT_REQUIREMENT'}]</td>
                    <td class="value">
                        [{isys type='f_text' name='idoitRequirement'}]
                        [{if $isEditMode}]
                            <br class="cb" />
                            <div class="ml20 mt5 input-size-normal">
                                <p class="text-blue">
                                    <img src="[{$dir_images}]axialis/basic/button-info.svg" alt="" class="vam mr5" />
                                    <span>[{isys type='lang' ident='LC__MODULE__PACKAGER__IDOIT_REQUIREMENT_DESCRIPTION'}]</span>
                                </p>
                            </div>
                        [{/if}]
                    </td>
                </tr>
                <tr>
                    <td class="key">[{isys type='f_label' name='createdOnPackagerVersion' ident='LC__MODULE__PACKAGER__CREATED_ON_PACKAGER_VERSION'}]</td>
                    <td class="value">[{isys type='f_text' name='createdOnPackagerVersion'}]</td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type='f_label' name='description' ident='LC__MODULE__PACKAGER__DESCRIPTION'}]</td>
                    <td class="value">[{isys type='f_textarea' name='description'}]</td>
                </tr>
            </table>
        </fieldset>

        <fieldset class="overview mt10">
            <legend>
                <button type="button" class="btn btn-small" data-hidden="1"><span>[{isys type='lang' ident='LC__MODULE__PACKAGER__TOGGLE_SHOW'}]</span></button>
                [{isys type='lang' ident='LC__MODULE__PACKAGER__SELECTED_OBJECT_TYPE_GROUPS'}] <em class="text-neutral-400">(<span class="item-counter">0</span> [{isys type='lang' ident='LC__MODULE__PACKAGER__SELECTED'}])</em>
            </legend>

            <table class="contentTable mt10 hide">
                <tr>
                    <td class="key">[{isys type="f_label" name="objectTypeGroup_uninstall" ident="LC__MODULE__PACKAGER__SELECTED_DELETE_DURING_UNINSTALL"}]</td>
                    <td class="value">[{isys type="f_dialog" name="objectTypeGroup_uninstall"}]</td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_OBJECT_TYPE_GROUPS_LABEL"}]</td>
                    <td class="value pl20">
                        <div id="object-type-group-selection" class="packager-item-selector"></div>
                        [{isys type='f_text' name='objectTypeGroup_selection' p_bInvisible=true}]
                    </td>
                </tr>
            </table>
        </fieldset>

        <fieldset class="overview mt10">
            <legend>
                <button type="button" class="btn btn-small" data-hidden="1"><span>[{isys type='lang' ident='LC__MODULE__PACKAGER__TOGGLE_SHOW'}]</span></button>
                [{isys type='lang' ident='LC__MODULE__PACKAGER__SELECTED_OBJECT_TYPES'}] <em class="text-neutral-400">(<span class="item-counter">0</span> [{isys type='lang' ident='LC__MODULE__PACKAGER__SELECTED'}])</em>
            </legend>

            <table class="contentTable mt10 hide">
                <tr>
                    <td class="key">[{isys type="f_label" name="objectType_uninstall" ident="LC__MODULE__PACKAGER__SELECTED_DELETE_DURING_UNINSTALL"}]</td>
                    <td class="value">[{isys type="f_dialog" name="objectType_uninstall"}]</td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_OBJECT_TYPES_LABEL"}]</td>
                    <td class="value pl20">
                        <div id="object-type-selection" class="packager-item-selector"></div>
                        [{isys type='f_text' name='objectType_selection' p_bInvisible=true}]
                    </td>
                </tr>
            </table>
        </fieldset>

        <fieldset class="overview mt10">
            <legend>
                <button type="button" class="btn btn-small" data-hidden="1"><span>[{isys type='lang' ident='LC__MODULE__PACKAGER__TOGGLE_SHOW'}]</span></button>
                [{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_CUSTOM_CATEGORIES"}] <em class="text-neutral-400">(<span class="item-counter">0</span> [{isys type='lang' ident='LC__MODULE__PACKAGER__SELECTED'}])</em>
            </legend>

            <table class="contentTable mt10 hide">
                <tr>
                    <td class="key">[{isys type="f_label" name="customCategory_uninstall" ident="LC__MODULE__PACKAGER__SELECTED_DELETE_DURING_UNINSTALL"}]</td>
                    <td class="value">[{isys type="f_dialog" name="customCategory_uninstall"}]</td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_CUSTOM_CATEGORIES_LABEL"}]</td>
                    <td class="value pl20">
                        <div id="custom-category-selection" class="packager-item-selector"></div>
                        [{isys type='f_text' name='customCategory_selection' p_bInvisible=true}]
                    </td>
                </tr>
            </table>
        </fieldset>

        <fieldset class="overview mt10">
            <legend>
                <button type="button" class="btn btn-small" data-hidden="1"><span>[{isys type='lang' ident='LC__MODULE__PACKAGER__TOGGLE_SHOW'}]</span></button>
                [{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_DIALOG_PLUS"}] <em class="text-neutral-400">(<span class="item-counter">0</span> [{isys type='lang' ident='LC__MODULE__PACKAGER__SELECTED'}])</em>
            </legend>

            <table class="contentTable mt10 hide">
                <tr>
                    <td class="key">[{isys type="f_label" name="dialog_plus_uninstall" ident="LC__MODULE__PACKAGER__SELECTED_DELETE_DURING_UNINSTALL"}]</td>
                    <td class="value">[{isys type="f_dialog" name="dialog_plus_uninstall"}]</td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_DIALOG_PLUS_LABEL"}]</td>
                    <td class="value pl20">
                        <div id="dialog-plus-selection" class="packager-item-selector"></div>
                        [{isys type='f_text' name='dialog_plus_selection' p_bInvisible=true}]
                    </td>
                </tr>
            </table>
        </fieldset>

        <fieldset class="overview mt10">
            <legend>
                <button type="button" class="btn btn-small" data-hidden="1"><span>[{isys type='lang' ident='LC__MODULE__PACKAGER__TOGGLE_SHOW'}]</span></button>
                [{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_REPORTS"}] <em class="text-neutral-400">(<span class="item-counter">0</span> [{isys type='lang' ident='LC__MODULE__PACKAGER__SELECTED'}])</em>
            </legend>

            <table class="contentTable mt10 hide">
                <tr>
                    <td class="key">[{isys type="f_label" name="report_uninstall" ident="LC__MODULE__PACKAGER__SELECTED_DELETE_DURING_UNINSTALL"}]</td>
                    <td class="value">[{isys type="f_dialog" name="report_uninstall"}]</td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_REPORTS_LABEL"}]</td>
                    <td class="value pl20">
                        <div id="report-selection" class="packager-item-selector"></div>
                        [{isys type='f_text' name='report_selection' p_bInvisible=true}]
                    </td>
                </tr>
            </table>
        </fieldset>

        <fieldset class="overview mt10">
            <legend>
                <button type="button" class="btn btn-small" data-hidden="1"><span>[{isys type='lang' ident='LC__MODULE__PACKAGER__TOGGLE_SHOW'}]</span></button>
                [{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_RELATION_TYPES"}] <em class="text-neutral-400">(<span class="item-counter">0</span> [{isys type='lang' ident='LC__MODULE__PACKAGER__SELECTED'}])</em>
            </legend>

            <table class="contentTable mt10 hide">
                <tr>
                    <td class="key">[{isys type="f_label" name="relation_type_uninstall" ident="LC__MODULE__PACKAGER__SELECTED_DELETE_DURING_UNINSTALL"}]</td>
                    <td class="value">[{isys type="f_dialog" name="relation_type_uninstall"}]</td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_RELATION_TYPES_LABEL"}]</td>
                    <td class="value pl20">
                        <div id="relation-type-selection" class="packager-item-selector"></div>
                        [{isys type='f_text' name='relation_type_selection' p_bInvisible=true}]
                    </td>
                </tr>
            </table>
        </fieldset>

        <fieldset class="overview mt10">
            <legend>
                <button type="button" class="btn btn-small" data-hidden="1"><span>[{isys type='lang' ident='LC__MODULE__PACKAGER__TOGGLE_SHOW'}]</span></button>
                [{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_CSV_IMPORT_PROFILES"}] <em class="text-neutral-400">(<span class="item-counter">0</span> [{isys type='lang' ident='LC__MODULE__PACKAGER__SELECTED'}])</em>
            </legend>

            <table class="contentTable mt10 hide">
                <tr>
                    <td class="key">[{isys type="f_label" name="csv_import_profile_uninstall" ident="LC__MODULE__PACKAGER__SELECTED_DELETE_DURING_UNINSTALL"}]</td>
                    <td class="value">[{isys type="f_dialog" name="csv_import_profile_uninstall"}]</td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_CSV_IMPORT_PROFILES_LABEL"}]</td>
                    <td class="value pl20">
                        <div id="csv-import-profile-selection" class="packager-item-selector"></div>
                        [{isys type='f_text' name='csv_import_profile_selection' p_bInvisible=true}]
                    </td>
                </tr>
            </table>
        </fieldset>

        <fieldset class="overview mt10">
            <legend>
                <button type="button" class="btn btn-small" data-hidden="1"><span>[{isys type='lang' ident='LC__MODULE__PACKAGER__TOGGLE_SHOW'}]</span></button>
                [{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_FILES"}] <em class="text-neutral-400">(<span class="item-counter">0 [{isys type='lang' ident='LC__MODULE__PACKAGER__FILES'}]</span>)</em>
            </legend>

            <table class="contentTable mt10 hide">
                <tr>
                    <td class="key">[{isys type="f_label" name="file_uninstall" ident="LC__MODULE__PACKAGER__SELECTED_DELETE_DURING_UNINSTALL"}]</td>
                    <td class="value">[{isys type="f_dialog" name="file_uninstall"}]</td>
                </tr>
                <tr>
                    <td class="key vat">[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_FILES_LABEL"}]</td>
                    <td class="value pl20">
                        <div id="file-selection"></div>
                    </td>
                </tr>
            </table>
        </fieldset>
    </div>

    <hr class="mt15 mb10" />

    <fieldset class="overview mt10">
        <legend>[{isys type="lang" ident="LC__MODULE__PACKAGER__CREATE_PACKAGE"}]</legend>

        <table class="contentTable mt10">
            <tr>
                <td class="key vat">[{isys type='lang' ident='LC__MODULE__PACKAGER__VERSION'}]</td>
                <td class="value">
                    [{isys type="f_text" name="newVersion"}]
                    <br class="cb" />
                    <p class="text-blue ml20 mt5">
                        <img src="[{$dir_images}]axialis/basic/button-info.svg" alt="" class="mr5 vam" />
                        [{if $lastVersion}]
                            [{isys type='lang' ident='LC__MODULE__PACKAGER__LATEST_VERSION_IS'}] [{$lastVersion}] -
                        [{else}]
                            [{isys type='lang' ident='LC__MODULE__PACKAGER__NO_LATEST_VERSION'}] -
                        [{/if}]
                        [{isys type='lang' ident='LC__MODULE__PACKAGER__VERSION_SYNTAX' p_bHtmlEncode=false}]
                    </p>
                </td>
            </tr>
            <tr>
                <td class="key">[{isys type='f_label' name='releaseDate' ident='LC__MODULE__PACKAGER__RELEASE_DATE'}]</td>
                <td class="value">[{isys type='f_popup' p_strPopupType='calendar' name='releaseDate'}]</td>
            </tr>
            <tr>
                <td class="key vat">[{isys type='f_label' name='changelog' ident='LC__MODULE__PACKAGER__CHANGELOG'}]</td>
                <td class="value">
                    [{isys type="f_textarea" name="changelog"}]
                    <br class="cb" />
                    <strong class="display-block ml20 mt5">[{isys type='lang' ident='LC__MODULE__PACKAGER__CHANGELOG_PREVIEW'}]</strong>
                    <pre id="changelogPreview" class="border">[{$previousChangelogData}]</pre>
                </td>
            </tr>
            <tr>
                <td></td>
                <td class="value pl20">
                    <p class="p5 mb5 box-yellow hide">
                        <img src="[{$dir_images}]axialis/construction/warning-sign.svg" class="vam mr5"/>
                        <span>[{isys type="lang" ident="LC__MODULE__PACKAGER__CONFIGURATION_CHANGED"}]</span>
                    </p>

                    <button id="package-creator" class="btn" type="button">
                        <img src="[{$dir_images}]axialis/development/addin-office.svg" alt="" /><span>[{isys type='lang' ident='LC__MODULE__PACKAGER__CREATE_PACKAGE'}]</span>
                    </button>
                </td>
            </tr>
        </table>
    </fieldset>

    <input type="hidden" name="addonId" value="[{$addonId}]" />
</div>

<style type="text/css">
    [{include file="`$packagerPath`assets/css/configuration.css"}]
    [{include file="`$packagerPath`assets/css/file-selector.css"}]
</style>

<script type="text/javascript">
    (function () {
        "use strict";

        var $root = $('add-on-packager'),
            $addonConfiguration = $('add-on-packager-configuration'),
            $identifier = $('identifier'),
            $manufacturer = $('manufacturer'),
            editMode = JSON.parse('[{if $isEditMode}]true[{else}]false[{/if}]'),
            $objectTypeGroup = $('object-type-group-selection'),
            $objectType = $('object-type-selection'),
            $customCategories = $('custom-category-selection'),
            $reports = $('report-selection'),
            $dialogPlus = $('dialog-plus-selection'),
            $relationType = $('relation-type-selection'),
            $csvImportProfile = $('csv-import-profile-selection'),
            $idoitRequirement = $('idoitRequirement'),
            $newVersion = $('newVersion'),
            $packageCreator = $('package-creator'),
            $saveButton = $('navbar_item_C__NAVMODE__SAVE'),
            $changelog = $('changelog'),
            $changelogPreview = $('changelogPreview'),
            reportNotification = false;

        $root.select('fieldset legend button').invoke('on', 'click', function(ev) {
            var $button = ev.findElement('button'),
                $table = $button.up('fieldset').down('table');

            if ($button.readAttribute('data-hidden') == '1') {
                $button.writeAttribute('data-hidden', 0).addClassName('pressed').down('span').update('[{isys type="lang" ident="LC__MODULE__PACKAGER__TOGGLE_HIDE"}]');
                $table.removeClassName('hide');
            } else {
                $button.writeAttribute('data-hidden', 1).removeClassName('pressed').down('span').update('[{isys type="lang" ident="LC__MODULE__PACKAGER__TOGGLE_SHOW"}]');
                $table.addClassName('hide');
            }
        });

        $packageCreator.on('click', function () {
            $packageCreator.disable();
            $packageCreator
                .down('img').addClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg')
                .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

            new Ajax.Request(window.www_dir + 'packager/ajax/createPackage', {
                parameters: {
                    addonId: '[{$addonId}]',
                    releaseDate: $F('releaseDate__HIDDEN'),
                    changelog: $changelog.getValue(),
                    version: $newVersion.getValue()
                },
                onComplete: function (xhr) {
                    $packageCreator
                        .down('img').removeClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/development/addin-office.svg')
                        .next('span').update('[{isys type="lang" ident="LC__MODULE__PACKAGER__CREATE_PACKAGE"}]');

                    try {
                        if (!is_json_response(xhr)) {
                            throw 'Creating a package responded in a non-JSON response.';
                        }

                        var json = xhr.responseJSON;

                        if (!json.success) {
                            throw 'Creating a package did not go successfully: ' + json.message;
                        }

                        document.location.href = '[{$baseUrl}]packager/repository/' + json.data.repositoryId;
                    } catch (e) {
                        idoit.Notify.error(e, {sticky: true});
                    }
                }
            });
        })

        if ($identifier)         {
            $identifier.on('keyup', function () {
                var identifier = $identifier.getValue().toLowerCase();

                // Replace all "non-word" characters (not alphabetic, numeric or underscore).
                identifier = identifier.replace(/[^a-z0-9_]/g, '');

                $identifier.setValue(identifier);
            });

            $identifier.on('blur', function () {
                var identifier = $identifier.getValue().toLowerCase();

                // Replace all "non-word" characters (not alphabetic, numeric or underscore).
                identifier = identifier.replace(/[^a-z0-9_]/g, '');

                // Remove all underscores from the start and end of the identifier.
                identifier = identifier.replace(/^[_]*/g, '');
                identifier = identifier.replace(/[_]*$/g, '');

                $identifier.setValue(identifier);
            });
        }

        if ($idoitRequirement) {
            $idoitRequirement.on('keyup', versionSanitizeOnkeyUp);
            $idoitRequirement.on('blur', versionSanitizeOnBlur);
        }

        if ($newVersion) {
            $newVersion.on('keyup', versionSanitizeOnkeyUp);
            $newVersion.on('blur', versionSanitizeOnBlur);

            if ($changelogPreview) {
                $newVersion.on('keyup', function () {
                    delay(updateChangelogPreview, 500);
                });
            }
        }


        if ($changelog && $changelogPreview) {
            $changelog.on('keyup', function () {
                delay(updateChangelogPreview, 500);
            });
        }

        function updateChangelogPreview() {
            if ($changelog.getValue().blank()) {
                $changelogPreview
                    .update("[{$previousChangelogData|escape:"javascript"}]");

                return;
            }

            $changelogPreview
                .update($newVersion.getValue())
                .insert('\n--------------------------------------------------------------------------------\n')
                .insert($changelog.getValue() + '\n\n')
                .insert("[{$previousChangelogData|escape:"javascript"}]");
        }

        // Observe changes inside the configuration.
        $addonConfiguration.on('change', 'input:not([type="radio"]),textarea,select', configurationChanged);

        function versionSanitizeOnkeyUp (ev) {
            var $input = ev.findElement('input'),
                version = $input.getValue();

            // Replace all "non-version" characters (not numeric, not a period).
            version = version.replace(/[^0-9\.]/g, '');

            // Only allow two periods: x.y.z
            version = version.split('.').slice(0,3).join('.');

            // Limit the version length to 16 characters.
            version = version.substr(0, 16);

            $input.setValue(version);
        }

        function versionSanitizeOnBlur (ev) {
            var $input = ev.findElement('input'),
                version = $input.getValue();

            // Replace all "non-version" characters (not numeric, not a period).
            version = version.replace(/[^0-9\.]/g, '');

            // Remove all periods from the start and end of the version.
            version = version.replace(/^[\.]*/g, '');
            version = version.replace(/[\.]*$/g, '');

            // Only allow two periods: x.y.z
            version = version.split('.').slice(0,3).join('.');

            // Limit the version length to 16 characters.
            version = version.substr(0, 16);

            $input.setValue(version);
        }

        function configurationChanged () {
            // Once we change anything, we'll disable the "package creator" and display a text.
            $packageCreator.disable();

            $packageCreator.previous().removeClassName('hide');
        }

        // Add the JS source.
        idoit.Require.addModule('packager.data-selector', '[{$packagerWwwPath}]assets/js/dataSelector.js');
        idoit.Require.addModule('packager.file-selector', '[{$packagerWwwPath}]assets/js/fileSelector.js');

        // Add some translations.
        idoit.Translate.set('LC__UNIVERSAL__LOADING', '[{isys type="lang" ident="LC__UNIVERSAL__LOADING" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC_UNIVERSAL__ACCEPT', '[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC_UNIVERSAL__ABORT', '[{isys type="lang" ident="LC_UNIVERSAL__ABORT" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC_UNIVERSAL__DELETE', '[{isys type="lang" ident="LC_UNIVERSAL__DELETE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILTER', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILTER" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__CONFIRM_DELETION', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__CONFIRM_DELETION" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__LABEL_DESCRIPTION', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__LABEL_DESCRIPTION" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__LABEL_DRAG_TEXT', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__LABEL_DRAG_TEXT" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__LABEL_FILENAME', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__LABEL_FILENAME" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__LABEL_NEW_FILE', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__LABEL_NEW_FILE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__LABEL_UPLOAD', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__LABEL_UPLOAD" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__LABEL_UPLOAD_BUTTON', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__LABEL_UPLOAD_BUTTON" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__LABEL_UPLOAD_CHANGE', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__LABEL_UPLOAD_CHANGE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__PROVIDE_FILE_AND_TITLE', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__PROVIDE_FILE_AND_TITLE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__TYPE_TRANSLATION', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__TYPE_TRANSLATION" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__TYPE_IMPORT_CSV', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__TYPE_IMPORT_CSV" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__TYPE_IMPORT_XML', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__TYPE_IMPORT_XML" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILE__TYPE_CUSTOM', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILE__TYPE_CUSTOM" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__FILES', '[{isys type="lang" ident="LC__MODULE__PACKAGER__FILES" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__SELECTED', '[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__AVAILABLE', '[{isys type="lang" ident="LC__MODULE__PACKAGER__AVAILABLE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__MODULE__PACKAGER__SELECTION_ERROR', '[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTION_ERROR" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__UNIVERSAL__ADD', '[{isys type="lang" ident="LC__UNIVERSAL__ADD" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__UNIVERSAL__REMOVE', '[{isys type="lang" ident="LC__UNIVERSAL__REMOVE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC_FILEBROWSER__SINGLE_FILE_UPLOAD', '[{isys type="lang" ident="LC_FILEBROWSER__SINGLE_FILE_UPLOAD" p_bHtmlEncode=false}]')

        idoit.Require.require('packager.data-selector', function () {
            var objectTypeGroupSelection = JSON.parse('[{$objectTypeGroupSelection|json_encode}]'),
                objectTypeSelection = JSON.parse('[{$objectTypeSelection|json_encode}]'),
                customCategorySelection = JSON.parse('[{$customCategorySelection|json_encode}]'),
                dialogPlusSelection = JSON.parse('[{$dialogPlusSelection|json_encode}]'),
                reportSelection = JSON.parse('[{$reportSelection|json_encode}]'),
                relationTypeSelection = JSON.parse('[{$relationTypeSelection|json_encode}]'),
                csvImportProfileSelection = JSON.parse('[{$csvImportProfileSelection|json_encode}]');

            $objectTypeGroup.up('fieldset').down('.item-counter').update(objectTypeGroupSelection.length);
            $objectType.up('fieldset').down('.item-counter').update(objectTypeSelection.length);
            $customCategories.up('fieldset').down('.item-counter').update(customCategorySelection.length);
            $dialogPlus.up('fieldset').down('.item-counter').update(dialogPlusSelection.length);
            $reports.up('fieldset').down('.item-counter').update(reportSelection.length);
            $relationType.up('fieldset').down('.item-counter').update(relationTypeSelection.length);
            $csvImportProfile.up('fieldset').down('.item-counter').update(csvImportProfileSelection.length);

            new DataSelector($objectTypeGroup, objectTypeGroupSelection, {
                $resultContainer: $('objectTypeGroup_selection'),
                callback: 'loadObjectTypeGroups',
                editMode: editMode,
                onChange: function (selection) {
                    $objectTypeGroup.up('fieldset').down('.item-counter').update(selection.length);
                    configurationChanged();
                }
            });
            new DataSelector($objectType, objectTypeSelection, {
                $resultContainer: $('objectType_selection'),
                callback: 'loadObjectTypes',
                editMode: editMode,
                onChange: function (selection) {
                    $objectType.up('fieldset').down('.item-counter').update(selection.length);
                    configurationChanged();
                }
            });
            new DataSelector($customCategories, customCategorySelection, {
                $resultContainer: $('customCategory_selection'),
                callback: 'loadCustomCategories',
                editMode: editMode,
                onChange: function (selection) {
                    $customCategories.up('fieldset').down('.item-counter').update(selection.length);
                    configurationChanged();
                }
            });
            new DataSelector($reports, reportSelection, {
                $resultContainer: $('report_selection'),
                callback: 'loadReports',
                editMode: editMode,
                onChange: function (selection) {
                    $reports.up('fieldset').down('.item-counter').update(selection.length);
                    configurationChanged();

                    if (!reportNotification) {
                        idoit.Notify.warning('[{isys type="lang" ident="LC__MODULE__PACKAGER__SELECTED_REPORTS_NOTIFICATION"}]', {sticky: true});
                        reportNotification = true;
                    }
                }
            });
            new DataSelector($dialogPlus, dialogPlusSelection, {
                $resultContainer: $('dialog_plus_selection'),
                callback: 'loadDialogPlus',
                editMode: editMode,
                onChange: function (selection) {
                    $dialogPlus.up('fieldset').down('.item-counter').update(selection.length);
                    configurationChanged();
                }
            });
            new DataSelector($relationType, relationTypeSelection, {
                $resultContainer: $('relation_type_selection'),
                callback: 'loadRelationTypes',
                editMode: editMode,
                onChange: function (selection) {
                    $relationType.up('fieldset').down('.item-counter').update(selection.length);
                    configurationChanged();
                }
            });
            new DataSelector($csvImportProfile, csvImportProfileSelection, {
                $resultContainer: $('csv_import_profile_selection'),
                callback: 'loadCsvImportProfiles',
                editMode: editMode,
                onChange: function (selection) {
                    $csvImportProfile.up('fieldset').down('.item-counter').update(selection.length);
                    configurationChanged();
                }
            });
        });

        idoit.Require.requireQueue(['fileUploader', 'packager.file-selector'], function () {
            var $fileSelector = $('file-selection');

            new FileSelector($fileSelector, {
                addonId: '[{$addonId}]',
                editMode: editMode,
                $itemCounter: $fileSelector.up('fieldset').down('.item-counter')
            })
        });

        if ($saveButton) {
            $saveButton.writeAttribute('onclick', "if(!window.checkMandatoryConfigurationFields()) {return false;}" + $saveButton.readAttribute('onclick'));

            window.checkMandatoryConfigurationFields = function () {
                $manufacturer.removeClassName('input-error');

                if ($manufacturer.getValue().blank()) {
                    $manufacturer.addClassName('input-error');
                    return false;
                }

                if ($identifier) {
                    $identifier.removeClassName('input-error');

                    if ($identifier.getValue().blank()) {
                        $identifier.addClassName('input-error');
                        return false;
                    }
                }

                return true;
            }
        }

        // Prevent the page-submit when pressing "Enter".
        $('add-on-packager').on('keydown', 'input', function (ev) {
            if (ev.keyCode === 13) {
                Event.stop(ev);
                return false;
            }
        });
    }());
</script>
