<div id="module-relocate-ci">
    <p class="p5">[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__RELOCATE_GUI_DESCRIPTION"}]</p>

    <table>
        <tr>
            <td class="vat p5" width="200px">
                <ul class="list-style-none m0 p0">
                    <li class="cb"><div class="cmdb-marker" style="background:#66C1FF;"></div> [{isys type="lang" ident="LC__MODULE__RELOCATE_CI__LOCATION_PHYSICAL"}]</li>
                    <li class="cb"><div class="cmdb-marker" style="background:#FFB85C;"></div> [{isys type="lang" ident="LC__MODULE__RELOCATE_CI__LOCATION_LOGICAL"}]</li>
                </ul>
            </td>
            <td id="module-relocate-ci-selected-object" class="vat p5">
                <!-- To be filled by JS -->
            </td>
        </tr>
    </table>

    <table id="module-relocate-ci-tree-container" class="m10">
        <tr>
            <td class="vat">
                <div class="tree-container border mr10">
                    <div class="p5 bg-neutral-200 border-bottom">
                        [{isys type="f_text" name="module-relocate-ci-source-search" disableInputGroup=true}]
                        [{isys type="f_text" name="module-relocate-ci-source-search-hidden" p_bInfoIconSpacer=0 p_bInvisible=true}]
                    </div>
                    <div id="relocate_ci_source_tree" class="dtree m10">
                        <!-- "Source" tree - display all CIs -->
                    </div>
                </div>
            </td>
            <td>
                <img src="[{$dir_images}]rsaquo.png" class="mt20 ml10 mr10" />
            </td>
            <td class="vat">
                <div class="tree-container border">
                    <div class="p5 bg-neutral-200 border-bottom">
                        [{isys type="f_text" name="module-relocate-ci-destination-search" disableInputGroup=true}]
                        [{isys type="f_text" name="module-relocate-ci-destination-search-hidden" p_bInfoIconSpacer=0 p_bInvisible=true}]
                    </div>
                    <div id="relocate_ci_destination_tree" class="dtree m10">
                        <!-- "Destination" tree - only container objects here -->
                    </div>
                </div>
            </td>
        </tr>
    </table>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        Position.includeScrollOffsets = true;

        var $tree_container = $('module-relocate-ci-tree-container'),
            $div_selected_object = $('module-relocate-ci-selected-object'),
            $div_source_tree = $('relocate_ci_source_tree'),
            $div_destination_tree = $('relocate_ci_destination_tree'),
            $navbar_relocate_button = $('navbar_item_relocate'),
            $ghost = new Element('div', {id: 'drag-ghost', className:'box-white p5'}),
            interval,
            source_tree,
            destination_tree,
            $interval_node,
            latestSelection = 0,
            initialize_left = function (selection) {
                // Remove the tree instances.
                $div_source_tree.update();

                source_tree = new eTree(
                    'relocate_ci_source_tree',
                    '[{$ajax_url_treelevel}]&tree_name=source',
                    '[{$dir_images}]axialis/construction/house-4.svg',
                    '[{isys type="lang" ident="LC__OBJ__ROOT_LOCATION"}]',
                    selection,
                    '[{$dir_images}]dtree/');

                // After we render a new sub-tree we need to create the "Draggables".
                source_tree.callback_after_render = source_after_render_callback;
            },
            initialize_right = function (selection) {
                // Remove the tree instances.
                $('relocate_ci_destination_tree').update();

                destination_tree = new eTree(
                    'relocate_ci_destination_tree',
                    '[{$ajax_url_treelevel}]&tree_name=destination',
                    '[{$dir_images}]axialis/construction/house-4.svg',
                    '[{isys type="lang" ident="LC__OBJ__ROOT_LOCATION"}]',
                    selection,
                    '[{$dir_images}]dtree/', null, null, null, true);

                // After we render a new sub-tree we need to create the "Droppables".
                destination_tree.callback_after_render = destination_after_render_callback;
            },
            zebra_trees = function ($tree) {
                var $nodes = $tree.select('.node-div')
                    .invoke('removeClassName', 'bg-white')
                    .invoke('removeClassName', 'bg-neutral-200');

                $nodes.filter(function($el, index) {return !!(index % 2);})
                    .invoke('addClassName', 'bg-neutral-200');

                $nodes.filter(function($el, index) {return !(index % 2);})
                    .invoke('addClassName', 'bg-white');
            },
            source_after_render_callback = function (parent, $parent) {
                var $radio = $parent.down('input[type="checkbox"][value="' + latestSelection + '"]');

                [{if $has_right}]
                $parent.setStyle({height: 'auto'}).select('.node-div:not(.root)').each(function ($el) {
                    // ID-1680 - Adding links to each object.
                    if ($el.readAttribute('data-object-id') > 1) {
                        const url = window.www_dir + '?[{$smarty.const.C__CMDB__GET__OBJECT}]=' + $el.readAttribute('data-object-id');

                        $el.insert({
                            top: new Element('a', { href: url, target: '_blank', className: 'fr' })
                                .update(new Element('img', {src:'[{$dir_images}]axialis/basic/link.svg', title:'[{isys type="lang" ident="LC__UNIVERSAL__TITLE_LINK"}] "' + $el.down('.node').textContent + '"'}))
                        });
                    }

                    new Draggable($el, {
                        ghosting: true,
                        revert: true,
                        zindex: 1200,
                        onStart: function (drag) {
                            var $drag = drag.element.addClassName('hide');

                            $ghost
                                .update($drag.down('.nodeIcon').clone(true).addClassName('mr5 vam'))
                                .insert(new Element('span', {className: 'vam'}).update($drag.down('span').innerText))
                                .appear({duration: 0.2});

                            interval = setInterval(hover_check, 400);
                        },
                        onDrag: function(drag) {
                            $ghost
                                .setStyle({
                                    left: (12 + window.mouseX) + 'px',
                                    top:  window.mouseY + 'px'
                                });
                        },
                        onEnd: function (drag) {
                            $ghost.fade({duration: 0.2});

                            // This is necessary for the tree, because it sets all elements to their inital height.
                            drag.element.removeClassName('hide').setStyle({height: 'auto', zIndex: 'auto'});

                            clearInterval(interval);
                        }
                    });
                });
                [{/if}]

                if ($radio) {
                    $radio.simulate('click');
                    latestSelection = 0;
                }

                disableSubLocations();

                zebra_trees($('relocate_ci_source_tree'));
            },
            destination_after_render_callback = function (parent, $parent) {
                var $radio = $parent.down('input[type="radio"][value="' + latestSelection + '"]');

                $parent.select('.node-div').each(function ($el) {
                    // ID-1680 - Adding links to each object.
                    if ($el.readAttribute('data-object-id') > 1) {
                        const url = window.www_dir + '?[{$smarty.const.C__CMDB__GET__OBJECT}]=' + $el.readAttribute('data-object-id');

                        $el.insert({
                            top: new Element('a', { href: url, target: '_blank', className: 'fr' })
                                .update(new Element('img', {src:'[{$dir_images}]axialis/basic/link.svg', title:'[{isys type="lang" ident="LC__UNIVERSAL__TITLE_LINK"}] "' + $el.down('.node').textContent + '"'}))
                        });
                    }

                    Droppables.add($el, {
                        hoverclass: 'drop',
                        onDrop: function ($source, $destination) {
                            var $sourceRadio = $source.down('input[type="radio"]'),
                                $destinationRadio = $destination.down('input[type="radio"]');

                            if ($sourceRadio) {
                                $sourceRadio.simulate('click');
                            }

                            if ($destinationRadio) {
                                $destinationRadio.simulate('click');
                            }

                            // Instead of duplicating a lot of code... We simply use the existing logic.
                            $navbar_relocate_button.fire('relocate:trigger');
                        }
                    });
                });

                if ($radio) {
                    $radio.simulate('click');
                    latestSelection = 0;
                }

                zebra_trees($('relocate_ci_destination_tree'));
            },
            hover_check = function () {
                var $hover_node = $tree_container.down('.drop');

                // If "$hover_node" and "$interval_node" are elements, and refer to the same element.
                if (Object.isElement($hover_node) && Object.isElement($interval_node) && $hover_node.readAttribute('data-object-id') == $interval_node.readAttribute('data-object-id')) {
                    // We check if the node is already open...
                    if (! $hover_node.down('.node-div')) {
                        // If not, we simulate a click on the "opener" image and load the children.
                        $hover_node.down('img[id]').simulate('click');
                    } else {
                        // If the node is already loaded but collapsed, we simply re-open it.
                        if (! $hover_node.down('.node-div').up().visible()) {
                            $hover_node.down('img[id]').simulate('click');
                        }
                    }
                }

                $interval_node = $hover_node;
            },
            responsive_options = function () {
                var $content_wrapper = $('contentWrapper'),
                    options_width = $content_wrapper.getWidth();

                if (options_width >= 1050) {
                    $tree_container.removeClassName('responsive-small').removeClassName('responsive-mini');
                } else if (options_width >= 840 && options_width < 1050) {
                    $tree_container.addClassName('responsive-small').removeClassName('responsive-mini');
                } else {
                    $tree_container.removeClassName('responsive-small').addClassName('responsive-mini');
                }
            };

        idoit.callbackManager.registerCallback('module-relocate-ci-update-tree', function (objects, destinationObjectId) {
            var i,
                $node,
                $destinationNode,
                parentId;

            if (objects.indexOf(1) >= 0) {
                initialize_left('');
            } else {
                for (i in objects) {
                    if (!objects.hasOwnProperty(i)) {
                        continue;
                    }

                    $node = $('relocate_ci_source_tree_Node_' + objects[i]);

                    if (!$node || !$node.up('.node-div')) {
                        continue;
                    }

                    parentId = $node.up('.node-div').readAttribute('data-object-id')

                    $node = $('relocate_ci_source_tree_ChildNodes_' + parentId);

                    if ($node) {
                        $node.update();
                        source_tree.loadedNodes[parentId] = false;
                        source_tree.expandedNodes[parentId] = false;
                        source_tree.LoadTree(parentId);
                    }
                }
            }

            if (destinationObjectId == 1) {
                initialize_right('');
            } else {
                $destinationNode = $('relocate_ci_destination_tree_ChildNodes_' + destinationObjectId);

                if ($destinationNode) {
                    $destinationNode.update();
                    source_tree.loadedNodes[destinationObjectId] = false;
                    source_tree.expandedNodes[destinationObjectId] = false;
                    destination_tree.LoadTree(destinationObjectId);
                }
            }
        });

        idoit.callbackManager.registerCallback('module-relocate-ci-search', function (tree) {
            var $hidden_field,
                value;

            if (tree == 'source') {
                $hidden_field = $('module-relocate-ci-source-search-hidden');
            } else {
                $hidden_field = $('module-relocate-ci-destination-search-hidden');
            }

            value = latestSelection = $hidden_field.getValue();

            // Get the location path of the selected object.
            new Ajax.Request('[{$ajax_url_location}]&func=get_logical_physical_path', {
                parameters: {
                    '[{$smarty.const.C__CMDB__GET__OBJECT}]': value
                },
                onComplete: function (transport) {
                    var json = transport.responseJSON, path;

                    is_json_response(transport, true);

                    if (json.success) {
                        path = json.data || [];
                        path.unshift('', value);

                        if (tree == 'source') {
                            initialize_left(path.join(','));
                        } else {
                            initialize_right(path.join(','));
                        }
                    } else {
                        idoit.Notify.error(json.message, {sticky:true});
                    }
                }
            });
        });

        $tree_container.on('change', 'input:not([type="text"])', function (ev) {
            var sourceObjects         = [],
                destintaionObject     = '[{isys_tenantsettings::get('gui.empty_value', '-')}]',
                $checkbox_destination = $div_destination_tree.down('input:checked');

            $tree_container.select('.active').invoke('removeClassName', 'active');

            disableSubLocations();

            $div_source_tree.select('input:checked').each(function ($checkbox) {
                $checkbox.up('.node-div').addClassName('active');

                sourceObjects.push(
                    new Element('strong').update($checkbox.next('span').textContent).outerHTML +
                    ' (#' + $checkbox.getValue() + ')'
                );
            });

            if ($checkbox_destination) {
                $checkbox_destination.up('.node-div').addClassName('active');
                destintaionObject = new Element('strong').update($checkbox_destination.next('span').textContent).outerHTML +
                                    ' (#' + $checkbox_destination.getValue() + ')';
            }

            if (sourceObjects.length === 0) {
                $div_selected_object.update('');

                return;
            }

            $div_selected_object
                .update(new Element('strong').update('[{isys type="lang" ident="LC__POPUP__BROWSER__SELECTED_OBJECTS"}]'))
                .insert(new Element('p', {className: 'mt5'}).update('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__RELOCATE_GUI_SELECTIONS" p_bHtmlEncode=false}]'));

            if (sourceObjects.length === 1) {
                $div_selected_object
                    .update(new Element('strong').update('[{isys type="lang" ident="LC__POPUP__BROWSER__SELECTED_OBJECT"}]'))
                    .insert(new Element('p', {className: 'mt5'}).update('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__RELOCATE_GUI_SELECTION" p_bHtmlEncode=false}]'));
            }

            $div_selected_object.down('.source').update(sourceObjects.join(', '));
            $div_selected_object.down('.destination').update(destintaionObject);
        });

        if ($navbar_relocate_button) {
            $navbar_relocate_button.on('relocate:trigger', function () {
                const $sources = $div_source_tree.select('input:checked');
                const $destination = $div_destination_tree.down('input:checked');
                const sourceData = [];

                if (!$destination || !$sources.length) {
                    idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__YOU_NEED_TO_SELECT_AT_LEAST_TWO_OBJECTS"}]');
                    return;
                }

                var $source,
                    $parent,
                    sourceObjectId,
                    sourceParentObjectId,
                    destinationObjectId = +$destination.getValue(),
                    $tmp,
                    sourceSelection = [],
                    destinationSelection = [],
                    i;

                // Check if there are any logical issues before going on...
                for (i in $sources) {
                    if (! $sources.hasOwnProperty(i)) {
                        continue;
                    }

                    $source = $sources[i];

                    sourceObjectId = +$source.getValue();
                    sourceParentObjectId = -1;

                    $parent = $source.up('.node-div', 1);

                    // Check if the user tries to move the object to itself.
                    if ($parent) {
                        sourceParentObjectId = +$parent.readAttribute('data-object-id');

                        if (sourceParentObjectId == destinationObjectId) {
                            idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__YOU_ARE_TRYING_TO_MOVE_AN_OBJECT_TO_ITS_CURRENT_LOCATION"}]');
                            return;
                        }
                    }

                    // Check if the user tries to move the object to itself.
                    if (sourceObjectId == destinationObjectId) {
                        idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__YOU_CANNOT_MOVE_AN_OBJECT_TO_ITSELF"}]');
                        return;
                    }

                    // Check if the user tries to move the object underneath itself.
                    if ($destination.up('[data-object-id="' + sourceObjectId + '"]')) {
                        idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__YOU_CANNOT_MOVE_AN_OBJECT_UNDERNEATH_ITSELF"}]');
                        return;
                    }

                    sourceData.push({
                        id: sourceObjectId,
                        parent: sourceParentObjectId
                    })
                }

                new Ajax.Request('[{$ajax_url}]&func=authorization-check', {
                    parameters: {
                        relocationObjects: JSON.stringify(sourceData),
                    },
                    onComplete: function (transport) {
                        var json = transport.responseJSON;

                        is_json_response(transport, true);

                        if (json.success) {
                            get_popup('relocate_ci_selection', '', 900, 500, {
                                relocationObjects: JSON.stringify(sourceData),
                                destinationObject: destinationObjectId
                            });
                        } else {
                            idoit.Notify.error(json.message, {sticky:true});
                        }
                    }
                });
            });
        }

        // This is necessary to not relocate objects that are already being relocated by their parents.
        function disableSubLocations () {
            $div_source_tree.select('input').invoke('enable');

            $div_source_tree.select('input:checked').each(function($checkbox) {
                $checkbox.up('.node-div').select('.node-div input').invoke('disable');
            });
        }

        // We need to listen to "window resizing" and dragging the navbar.
        Event.observe(window, 'resize', responsive_options);
        idoit.callbackManager.registerCallback('idoit-dragbar-update', responsive_options);

        initialize_left('');
        initialize_right('');
        $('module-relocate-ci-source-search').focus();

        // And trigger the responsive observer, when the page loads.
        responsive_options();

        $('body').insert($ghost);
    })();
</script>

<style>
    #module-relocate-ci {
        box-sizing: border-box;
        position: relative;
    }

    #relocate_ci_source_tree,
    #relocate_ci_destination_tree {
        min-height: 250px;
        max-height: 400px;
        overflow-x: hidden;
        overflow-y: auto;
    }

    #drag-ghost {
        position: absolute;
        z-index: 1300;
    }

    #module-relocate-ci .tree-container {
        width: 450px;
        background: #ffffff;
    }

    #module-relocate-ci-tree-container {
        position: relative;
    }

    #module-relocate-ci-tree-container .node-div.active {
        background: #d4ffde;
    }

    #module-relocate-ci-tree-container .node-div a.fr {
        position: relative;
        z-index: 700;
        top: 2px;
    }

    #module-relocate-ci-tree-container.responsive-small .tree-container {
        width: 350px;
    }

    #module-relocate-ci-tree-container.responsive-mini {
        width: 100%;
    }

    #module-relocate-ci-tree-container.responsive-mini .tree-container {
        width: 100%;
    }

    #module-relocate-ci .tree-container .drop {
        background: #d4ffde;
        border-top: 1px solid #487854;
        border-bottom: 1px solid #487854;
    }

    #module-relocate-ci .responsive-mini #relocate_ci_source_tree,
    #module-relocate-ci .responsive-mini #relocate_ci_destination_tree {
        overflow-x: auto;
    }
</style>
