<?php

/**
 * i-doit
 *
 * UI: global category for Relocate-CI.
 *
 * @package     Modules
 * @subpackage  Check_MK
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5.0
 */
class isys_cmdb_ui_category_g_virtual_relocate_ci extends isys_cmdb_ui_category_g_virtual
{
    /**
     * Processes view/edit mode.
     *
     * @param isys_cmdb_dao_category $p_cat
     */
    public function process(isys_cmdb_dao_category $p_cat)
    {
        $objectId = $p_cat->convert_sql_id($p_cat->get_object_id());

        isys_component_template_navbar::getInstance()
            ->hide_all_buttons();

        $result = $p_cat
            ->getLogbookInfoResult($objectId);

        $this->deactivate_commentary()
            ->get_template_component()
            ->assign('result', $result)
            ->assign('empty_result', 'LC__CATG__VIRTUAL_RELOCATE_CI__NO_LOGS')
            ->include_template('contentbottomcontent', isys_module_relocate_ci::getPath() . 'templates/relocate_logbook.tpl');
    }
}
