<?php

/**
 * i-doit
 *
 * Relocate-CI DAO.
 *
 * @package     modules
 * @subpackage  relocate_ci
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_relocate_ci_dao extends isys_cmdb_dao
{
    /**
     * Returns a formatted description, which locations have been changed.
     *
     * @param string|null $p_changes
     *
     * @return string
     * @throws isys_exception_database
     */
    public static function render_changes(?string $p_changes = null)
    {
        if (empty($p_changes)) {
            return '';
        }

        $language = isys_application::instance()->container->get('language');
        $cmdbDao = isys_cmdb_dao::instance(isys_application::instance()->container->get('database'));

        // @see RELOCATE-42
        // @todo Update this code to use 'Unserialize::toArray()' after i-doit 25 release.
        $p_changes = unserialize($p_changes, ['allowed_classes' => false]);

        if (isset($p_changes['C__CATG__LOCATION_PARENT'])) {
            $message = 'LC__MODULE__RELOCATE_CI__SIMPLE_LOGBOOK__PHYSICAL_LOCATION_CHANGED_IN_CMDB';
        } elseif (isset($p_changes['C__CMDB__CATG__LOGICAL_UNIT__PARENT'])) {
            $message = 'LC__MODULE__RELOCATE_CI__SIMPLE_LOGBOOK__LOGICAL_LOCATION_CHANGED_IN_CMDB';
        } elseif (isset($p_changes['isys_cmdb_dao_category_g_location::parent'])) {
            $message = 'LC__MODULE__RELOCATE_CI__SIMPLE_LOGBOOK__PHYSICAL_LOCATION_CHANGED_IN_ADDON';
        } elseif (isset($p_changes['isys_cmdb_dao_category_g_logical_unit::parent'])) {
            $message = 'LC__MODULE__RELOCATE_CI__SIMPLE_LOGBOOK__LOGICAL_LOCATION_CHANGED_IN_ADDON';
        } else {
            return '';
        }

        // We can do this, because the "Relocate-CI" logbook entry will only contain one of both.
        $l_values = current($p_changes);

        if (is_numeric($l_values['from'])) {
            $l_from = $cmdbDao->get_object_by_id($l_values['from'], true)
                ->get_row();

            if (is_array($l_from)) {
                $l_from_data = '<strong>' . $l_from['isys_obj__title'] . '</strong>';
            } else {
                $l_from_data = '<em class="text-neutral-400">' . $language->get('LC__MODULE__RELOCATE_CI__OBJ_DOES_NOT_EXIST') . '</em>';
            }
        } elseif (!empty($l_values['from'])) {
            $l_from_data = '<strong>' . $l_values['from'] . '</strong>';
        } else {
            $l_from_data = '<em class="text-neutral-400">' . $language->get('LC__UNIVERSAL__EMPTY') . '</em>';
        }

        if (is_numeric($l_values['to'])) {
            $l_to = $cmdbDao->get_object_by_id($l_values['to'], true)
                ->get_row();

            if (is_array($l_to)) {
                $l_to_data = '<strong>' . $l_to['isys_obj__title'] . '</strong>';
            } else {
                $l_to_data = '<em class="text-neutral-400">' . $language->get('LC__MODULE__RELOCATE_CI__OBJ_DOES_NOT_EXIST') . '</em>';
            }
        } else if (!empty($l_values['to'])) {
            $l_to_data = '<strong>' . $l_values['to'] . '</strong>';
        } else {
            $l_to_data = '<em class="text-neutral-400">' . $language->get('LC__UNIVERSAL__EMPTY') . '</em>';
        }

        return $language->get($message, [$l_from_data, $l_to_data]);
    }
}
