<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     modules
 * @subpackage  relocate_ci
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Psr4AutoloaderClass;

if (isys_module_manager::instance()->is_active('relocate_ci')) {
    Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\RelocateCi', __DIR__ . '/src/');

    Autoloader::appendClassmap(require __DIR__ . '/classmap.php');

    $template = isys_application::instance()->container->get('template');

    $template->appendInlineJavascript($template->fetch(__DIR__ . '/templates/relocate-ci-inline.js'));

    isys_tenantsettings::extend([
        'LC__MODULE__RELOCATE_CI' => [
            'relocate-ci.reset-logical-location-after-physical-relocation' => [
                'title'   => 'LC__MODULE__RELOCATE_CI__SETTING__RESET_LOGICAL_AFTER_PHYSICAL_RELOCATION',
                'type'    => 'select',
                'options' => [
                    '0' => 'LC__UNIVERSAL__NO',
                    '1' => 'LC__UNIVERSAL__YES'
                ]
            ],
            'relocate-ci.update-physical-location-after-logical-relocation' => [
                'title'   => 'LC__MODULE__RELOCATE_CI__SETTING__UPDATE_PHYSICAL_AFTER_LOGICAL_RELOCATION',
                'type'    => 'select',
                'options' => [
                    '0' => 'LC__UNIVERSAL__NO',
                    '1' => 'LC__UNIVERSAL__YES'
                ]
            ],
            'relocate-ci.write-logbook-changes-to-children' => [
                'title'   => 'LC__MODULE__RELOCATE_CI__SETTING__WRITE_LOGBOOK_CHANGES_TO_CHILDREN',
                'type'    => 'select',
                'options' => [
                    '0' => 'LC__UNIVERSAL__NO',
                    '1' => 'LC__UNIVERSAL__YES'
                ]
            ]
        ]
    ]);
}
