<?php

use idoit\Module\RelocateCi\Model\Ci;

/**
 * i-doit
 *
 * Relocate-CI popup selection.
 *
 * @package     modules
 * @subpackage  relocate_ci
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_relocate_ci_selection extends isys_component_popup
{
    /**
     * Empty method since this popup will not be displayed as form field.
     *
     * @param isys_component_template $p_tplclass
     * @param array                   $p_params
     */
    public function handle_smarty_include(isys_component_template &$p_tplclass, $p_params)
    {
        // Nothing to do here.
    }

    /**
     * Method for handling the module request.
     *
     * @param isys_module_request $p_modreq
     *
     * @return  null
     * @throws  isys_exception_database
     * @throws  isys_exception_general
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        global $g_dirs;

        $relocateDao = isys_relocate_ci_dao::instance($this->database);
        $ciModel = Ci::instance($this->database);

        $relocationObjects = isys_format_json::decode($_POST['relocationObjects']);
        $destinationObjectId = (int)$_POST['destinationObject'];

        foreach ($relocationObjects as &$relocationObject) {
            if ($relocationObject['parent'] === -1) {
                $relocationObject['parent'] = (int)defined_or_default('C__OBJ__ROOT_LOCATION', 1);
            }

            $relocationObject['data'] = $this->prepareObjectData($relocationObject['id']);
            $relocationObject['parentData'] = $this->prepareObjectData($relocationObject['parent']);

            if ($ciModel->usableForPhysicalRelocation($relocationObject['id'])) {
                $relocationObject['children'] = false;

                continue;
            }

            $relocationObject['children'] = $ciModel->getLocatedObjects($relocationObject['id']);

            // We need to iterate through the children to find out if there are any workstations attached to it (in case we are moving a person).
            foreach ($relocationObject['children'] as &$child) {
                if ($child['typeConst'] === 'C__OBJTYPE__WORKSTATION') {
                    $child['children'] = $ciModel->getLocatedObjects($child['id']);

                    // If the workstation has no children we remove the array key.
                    if (count($child['children']) === 0) {
                        unset ($child['children']);
                    }
                }
            }
        }

        $relocationParent = [
            'title'     => $this->language->get('LC__MODULE__RELOCATE_CI__POPUP_MULTIPLE_OBJECTS'),
            'image'     => isys_application::instance()->container->get('route_generator')
                ->generate('cmdb.object-type.image-name', ['filename' => C__OBJTYPE_IMAGE__DEFAULT]),
            'typeTitle' => $this->language->get('LC__MODULE__RELOCATE_CI__POPUP_MULTIPLE_TYPES'),
            'typeIcon'  => Ci::objectTypeIconPath(null)
        ];

        if (count($relocationObjects) === 1) {
            $relocationParent = $relocationObjects[0]['parentData'];
        }

        $this->template
            ->assign('sourceParent', $relocationParent)
            ->assign('sources', $relocationObjects)
            ->assign('dummy', $this->prepareObjectData(defined_or_default('C__OBJ__ROOT_LOCATION', 1)))
            ->assign('parentLocations', implode(',', array_map(function ($object) { return $object['parent']; }, $relocationObjects)))
            ->assign('destination', $this->prepareObjectData($destinationObjectId))
            ->assign('ajax_url', isys_helper_link::create_url([C__GET__AJAX_CALL => 'relocate_ci', C__GET__AJAX => 1]))
            ->display(isys_module_relocate_ci::getPath() . 'templates/popup_selection.tpl');
        die;
    }

    /**
     * Method for retrieving the necessary object information.
     *
     * @param integer $objectId
     *
     * @return array
     */
    private function prepareObjectData(int $objectId)
    {
        global $g_dirs;

        // If we get something like "-1" or so, we usually work with the root location.
        if ($objectId <= 0) {
            $objectId = defined_or_default('C__OBJ__ROOT_LOCATION', 1);
        }

        $row = isys_application::instance()->container->get('cmdb_dao')
            ->get_object_by_id($objectId)
            ->get_row();

        return [
            'id'        => $objectId,
            'title'     => $row['isys_obj__title'],
            'image'     => isys_application::instance()->container->get('route_generator')
                ->generate('cmdb.object.image', ['objectId' => (int)$objectId]),
            'typeConst' => $row['isys_obj_type__const'],
            'typeTitle' => $this->language->get($row['isys_obj_type__title']),
            'typeIcon'  => Ci::objectTypeIconPath((int)$row['isys_obj_type__id'])
        ];
    }
}
