<div id="module-relocate-ci-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__SELECTION_BROWSER"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img alt="close" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content">
        <div class="overlay hide"></div>
        <table id="module-relocate-ci-popup-selection" class="w100">
            <tr>
                <td width="45%" class="vat">
                    <table class="w100" style="height:130px;">
                        <tr>
                            <td class="vat" width="100px">
                                <img src="[{$sourceParent.image}]" class="obj-image" alt="[{isys type="lang" ident="LC__CMDB__CATG__IMAGE"}]" title="[{isys type="lang" ident="LC__CMDB__CATG__IMAGE"}]" />
                            </td>
                            <td class="vat p5">
                                <img src="[{$sourceParent.typeIcon}]" height="16" class="vam mr5"/>
                                <span class="vam">[{$sourceParent.typeTitle}] &raquo; [{$sourceParent.title}]</span>
                            </td>
                        </tr>
                    </table>

                    <div class="left-selection mt10 pt5">
                        <ul>
                            <li class="pl5">
                                <img height="16" src="[{$dir_images}]axialis/basic/button-info.svg" class="vam mr5" />
                                <span class="vam text-blue">[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__POPUP_ALL_OBJECTS_WILL_BE_RELOCATED"}]</span>
                            </li>
                        </ul>
                    </div>
                </td>
                <td width="10%" class="vat center">
                    <img src="[{$dir_images}]rsaquo.png" class="arrow" />
                </td>
                <td width="45%" class="vat">
                    <table class="w100" style="height:130px;">
                        <tr>
                            <td class="vat" width="100px">
                                <img src="[{$destination.image}]" class="obj-image" alt="[{isys type="lang" ident="LC__CMDB__CATG__IMAGE"}]" title="[{isys type="lang" ident="LC__CMDB__CATG__IMAGE"}]" />
                            </td>
                            <td class="vat p5">
                                <img src="[{$destination.typeIcon}]" height="16" class="vam mr5"/>
                                <span class="vam">[{isys type="lang" ident=$destination.typeTitle}] &raquo; [{$destination.title}]</span>
                            </td>
                        </tr>
                    </table>

                    <div class="right-selection mt10 pt5">
                        [{foreach $sources as $source}]
                            <div class="relocation-object" data-fallback-parent-id="[{$source.parent}]">
                                <img src="[{$source.data.typeIcon}]" height="16" class="vam mr5"/>
                                <span class="vam truncate">[{isys type="lang" ident=$source.data.typeTitle}] &raquo; [{$source.data.title}]</span>
                            </div>

                            [{if is_array($source.children) && count($source.children)}]
                                <ul data-parent-id="[{$source.id}]">
                                    [{foreach $source.children as $child}]
                                        <li>
                                            <label>
                                                <input type="checkbox" value="[{$child.id}]" data-obj-id="[{$child.id}]" data-obj-type-const="[{$child.typeConst}]" data-fallback-parent-id="[{$source.parent}]" class="mr5" checked="checked">
                                                <img src="[{$child.typeIcon}]" class="vam mr5" />
                                                <span class="vam truncate">[{$child.typeTitle}] &raquo; [{$child.title}]</span>
                                            </label>

                                            [{if is_array($child.children) && count($child.children)}]
                                                <ul data-parent-id="[{$child.id}]">
                                                    [{foreach $child.children as $sub_child}]
                                                        <li>
                                                            <label>
                                                                <input type="checkbox" value="[{$sub_child.id}]" data-obj-id="[{$sub_child.id}]" data-obj-type-const="[{$sub_child.typeConst}]" data-fallback-parent-id="[{$source.parent}]" class="mr5" checked="checked">
                                                                <img src="[{$sub_child.typeIcon}]" class="vam mr5" />
                                                                <span class="vam truncate">[{$sub_child.typeTitle}] &raquo; [{$sub_child.title}]</span>
                                                            </label>
                                                        </li>
                                                    [{/foreach}]
                                                </ul>
                                            [{/if}]
                                        </li>
                                    [{/foreach}]
                                </ul>
                            [{/if}]

                            <hr class="mt5 mb5" />
                        [{/foreach}]
                    </div>
                </td>
            </tr>
        </table>

        <div class="mt5 p5" style="display:none;">
            <table id="module-relocate-ci-popup-result" class="mainTable border">
                <tr>
                    <th>
                        <button type="button" class="btn btn-small fr">
                            <span>[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__RESULT_DETAILLED_INFO"}]</span>
                        </button>

                        [{isys type="lang" ident="LC__MODULE__RELOCATE_CI__RESULT"}]
                    </th>
                </tr>

                <!-- Results go here -->
            </table>
        </div>
    </div>

    <div id="module-relocate-ci-popup-footer" class="popup-footer-ng">
        <button type="button" class="btn mr5" id="module-relocate-ci-popup-start-relocation">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt="" /><span>[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__POPUP_RELOCATE_BUTTON"}]</span>
        </button>

        <button type="button" class="btn popup-closer" id="module-relocate-ci-popup-cancel">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__CMDB__BROWSER_OBJECT__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        const sources = JSON.parse('[{$sources|json_encode|escape:"javascript"}]');

        var $popup = $('module-relocate-ci-popup'),
            $relocation_button = $('module-relocate-ci-popup-start-relocation'),
            $selection = $('module-relocate-ci-popup-selection'),
            $result_table = $('module-relocate-ci-popup-result'),
            close_and_reload = false;

        $popup.select('.popup-closer').invoke('on', 'click', function () {
            if (close_and_reload) {
                var objectsToReloadInTree = sources.map(function (source) { return source.id; });

                objectsToReloadInTree.push(+'[{$destination.id}]');

                $selection.select('input:not(:checked):not([disabled])').map(function ($checkbox) {
                    objectsToReloadInTree.push(+$checkbox.readAttribute('value'));
                    objectsToReloadInTree.push(+$checkbox.readAttribute('data-fallback-parent-id'));
                })

                $selection.select('.relocation-object').map(function($node) {
                    objectsToReloadInTree.push(+$node.readAttribute('data-fallback-parent-id'));
                });

                idoit.callbackManager.triggerCallback('module-relocate-ci-update-tree', objectsToReloadInTree.uniq(), '[{$destination.id}]');
            }

            popup_close();
        });

        // En- and Disable checkboxes, when the parent gets clicked.
        $selection.on('change', 'input', function (ev) {
            var $input = ev.findElement('input'),
                $uncheckedObjects,
                $child_list = $input.up('li').down('ul'),
                $left_selection = $selection.down('.left-selection ul'),
                $right_selection = $selection.down('.right-selection'),
                $dummy = new Element('li', {className:'pb10 pl5'})
                    .update(new Element('img', {src:'[{$dummy.typeIcon}]', height:16, className:'vam mr5'}))
                        .insert(new Element('span', {className:'vam'}).update('[{isys type="lang" ident=$dummy.typeTitle}] &raquo; [{$dummy.title}]'))
                        .insert(new Element('ul', {'data-parent-id': '[{$dummy.id}]'}));

            if ($child_list) {
                if ($input.checked) {
                    $child_list.select('input').invoke('enable').invoke('setValue', '1');
                } else {
                    $child_list.select('input').invoke('disable').invoke('setValue', '');
                }
            }

            $uncheckedObjects = $right_selection.select('input:not(:checked):not(:disabled)');

            if (!$uncheckedObjects.length) {
                $left_selection
                    .update(new Element('li', {className: 'pl5'})
                        .update(new Element('img', {className: 'vam mr5', height: 16, src: window.dir_images + 'axialis/basic/button-info.svg'}))
                        .insert(new Element('span', {className: 'vam text-blue'})
                            .update('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__POPUP_ALL_OBJECTS_WILL_BE_RELOCATED"}]')));
                return;
            }

            // And now we update the left selection area.
            $left_selection.update($dummy);
            $uncheckedObjects.each(function ($el) {
                var $target = $dummy;

                // Find the "upmost" parent to display it on the left, we only need two iterations.
                var $parentList = $el.up('ul');

                if ($parentList.up('ul')) {
                    $parentList = $parentList.up('ul');
                }

                const parentObjectId = +$parentList.readAttribute('data-parent-id');

                var foundParent = sources.find(function(source) {
                    return source.id === parentObjectId;
                });

                if (foundParent) {
                    $target = $left_selection.down('[data-object-id="' + foundParent.parent + '"]');

                    if (!$target) {
                        $target = new Element('ul', {'data-object-id': foundParent.parent});

                        $left_selection.insert(new Element('li', {className:'pb10 pl5'})
                            .update(new Element('img', {className: 'vam mr5', src: foundParent.parentData.typeIcon}))
                            .insert(new Element('span', {className: 'vam truncate'})
                                .update(foundParent.parentData.typeTitle + ' &raquo; ' + foundParent.parentData.title))
                            .insert($target));
                    }
                }

                $target
                    .insert(new Element('li', {className:'pt5 pl5', 'data-object-id': $el.readAttribute('data-obj-id')})
                        .update($el.next('img').outerHTML)
                        .insert($el.next('span').outerHTML)
                        .insert(new Element('ul')));
            });

            // Remove the dummy if it was not used :(
            if (!$dummy.select('li').length) {
                $dummy.remove();
            }
        });

        $result_table.on('click', 'button', function (ev) {
            ev.findElement('button').remove();

            $result_table.select('tr.hide').invoke('removeClassName', 'hide');
        });

        $relocation_button.on('click', function () {
            if (close_and_reload) {
                $popup.down('.popup-closer').simulate('click');
                return;
            }

            $popup.down('.overlay').removeClassName('hide');

            $relocation_button
                .down('img').addClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg')
                .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

            const children = $selection.select('input:not(:checked):not([disabled])').map(function($child) {
                return {
                    id:$child.readAttribute('value'),
                    newParent:+$child.readAttribute('data-fallback-parent-id')
                };
            });

            $popup.select('input').invoke('disable');

            new Ajax.Request('[{$ajax_url}]&func=relocate', {
                parameters: {
                    relocationObjects: JSON.stringify(sources.map(function(source) { return source.id; })),
                    destinationObjectId: '[{$destination.id}]',
                    children: JSON.stringify(children)
                },
                onComplete: function (transport) {
                    var json = transport.responseJSON, i;

                    $popup.down('.overlay').addClassName('hide');

                    if (json.success) {
                        // On Success:
                        $relocation_button
                            .down('img').removeClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/basic/symbol-update.svg')
                            .next('span').update('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__POPUP_CLOSE_AND_RELOAD"}]');

                        $('module-relocate-ci-popup-cancel').disable();

                        close_and_reload = true;

                        for (i in json.data.log) {
                            if (json.data.log.hasOwnProperty(i)) {
                                $result_table
                                    .insert(new Element('tr', {className:'hide text-' + json.data.log[i].color})
                                        .update(new Element('td')
                                            .update(new Element('img', {src: json.data.log[i].icon, className: 'vam mr5'}))
                                            .insert(new Element('span', {className: 'vam'})
                                                .update(json.data.log[i].message))));
                            }
                        }

                        $result_table.insert(new Element('tr').update(new Element('td', {className:'green border-top'})
                            .update(new Element('img', {className:'vam mr5', src:window.dir_images + 'axialis/basic/symbol-ok.svg'}))
                            .insert(new Element('span', {className:'vam'}).update(json.data.message))));
                    } else {
                        // On failure:
                        $relocation_button
                            .down('img').removeClassName('animation-rotate').writeAttribute('src', window.dir_images + 'axialis/basic/warning.svg')
                            .next('span').update('[{isys type="lang" ident="LC__MODULE__RELOCATE_CI__POPUP_ERROR_OCCURRED"}]');

                        $result_table.insert(new Element('tr').update(new Element('td', {className:'box-red'}).update(json.message)));
                    }

                    Effect.BlindDown($result_table.up('div'), {duration: 1});
                }
            });
        });
    })();
</script>

<style>
    #module-relocate-ci-popup .overlay {
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        background: rgba(255, 255, 255, .5);
        z-index: 100;
    }

    #module-relocate-ci-popup .arrow {
        margin-top: 150px;
    }

    #module-relocate-ci-popup ul,
    #module-relocate-ci-popup li {
        list-style: none;
        margin: 0 0 0 5px;
        padding: 0;
    }

    #module-relocate-ci-popup label {
        display: block;
        margin: 0 3px;
    }

    #module-relocate-ci-popup img.obj-image {
        width: 100px;
        max-width: 100px;
        height: auto;
        max-height: 100px;
        border: 1px solid rgba(0, 0, 0, .4);
    }

    #module-relocate-ci-popup .truncate {
        display: inline-block;
        max-width: 320px;
        position: relative;
        text-overflow: ellipsis;
        overflow: hidden;
        white-space: nowrap;
    }
</style>
