<?php

/**
 * i-doit
 *
 * Auth: Class for i-doit authorization rules.
 *
 * @package     Modules
 * @subpackage  Analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5.0
 */
class isys_auth_relocate_ci extends isys_auth implements isys_auth_interface
{
    /**
     * Container for singleton instance
     *
     * @var isys_auth_relocate_ci
     */
    private static $m_instance;

    /**
     * Method for returning the available auth-methods. This will be used for the GUI.
     *
     * @return  array
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function get_auth_methods()
    {
        return [
            'relocate_logbook' => [
                'title'  => 'LC__MODULE__RELOCATE_CI__LOGBOOK_GUI',
                'type'   => 'boolean',
                'rights' => [isys_auth::VIEW]
            ],
            'relocate_gui'     => [
                'title'  => 'LC__MODULE__RELOCATE_CI__RELOCATE_GUI',
                'type'   => 'boolean',
                'rights' => [isys_auth::VIEW, isys_auth::EXECUTE]
            ]
        ];
    }

    /**
     * Method for checking, if the user is allowed to view / execute a simulation.
     *
     * @param   integer $p_right
     *
     * @return  boolean
     * @throws  isys_exception_auth
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function relocate_logbook($p_right)
    {
        if (!$this->is_auth_active()) {
            return true;
        }

        return $this->generic_boolean('relocate_logbook', new isys_exception_auth(_L('LC__MODULE__RELOCATE_CI__YOU_ARE_NOT_ALLOWED_TO_OPEN_THE_LOGBOOK')), $p_right);
    }

    /**
     * Method for checking, if the user is allowed to administrate dataquality profiles (add, delete, publish).
     *
     * @param   integer $p_right
     *
     * @return  boolean
     * @throws  isys_exception_auth
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function relocate_gui($p_right)
    {
        if (!$this->is_auth_active()) {
            return true;
        }

        if ($p_right == isys_auth::VIEW) {
            $l_exception = new isys_exception_auth(_L('LC__MODULE__RELOCATE_CI__YOU_ARE_NOT_ALLOWED_TO_VIEW_THE_RELOCATION_GUI'));
        } else {
            $l_exception = new isys_exception_auth(_L('LC__MODULE__RELOCATE_CI__YOU_ARE_NOT_ALLOWED_TO_EXECUTE_THE_RELOCATION'));
        }

        return $this->generic_boolean('relocate_gui', $l_exception, $p_right);
    }

    /**
     * Get ID of related module
     *
     * @return int
     */
    public function get_module_id()
    {
        return C__MODULE__RELOCATE_CI;
    }

    /**
     * Get title of related module
     *
     * @return string
     */
    public function get_module_title()
    {
        return "LC__MODULE__RELOCATE_CI";
    }

    /**
     * Retrieve singleton instance of authorization class
     *
     * @return isys_auth_relocate_ci
     * @author Selcuk Kekec <skekec@i-doit.com>
     */
    public static function instance()
    {
        // If the DAO has not been loaded yet, we initialize it now.
        if (self::$m_dao === null) {
            self::$m_dao = new isys_auth_dao(isys_application::instance()->container->get('database'));
        }

        if (self::$m_instance === null) {
            self::$m_instance = new self;
        }

        return self::$m_instance;
    }
}
