<?php

use idoit\Component\Property\Property;
use idoit\Component\Property\Type\DynamicProperty;

/**
 * i-doit
 *
 * DAO: class for global category "Relocate-CI".
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_category_g_virtual_relocate_ci extends isys_cmdb_dao_category_g_virtual
{
    /**
     * @var string
     */
    protected $m_category = 'virtual_relocate_ci';

    /**
     * @return array
     * @throws \idoit\Component\Property\Exception\UnsupportedConfigurationTypeException
     */
    protected function dynamic_properties()
    {
        return [
            '_changed' => (new DynamicProperty(
                'LC__CATG__VIRTUAL_RELOCATE_CI__HEADER',
                'isys_catg_global_list__isys_obj__id',
                'isys_catg_global_list',
                [$this, 'dynamic_property_callback_changed']
            ))->mergePropertyProvides([
                    Property::C__PROPERTY__PROVIDES__VIRTUAL => true
            ]),
        ];
    }

    /**
     * @param $objectId
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     */
    public function getLogbookInfoResult($objectId)
    {
        $l_sql = "SELECT * FROM isys_logbook
			INNER JOIN isys_catg_logb_list ON isys_catg_logb_list__isys_logbook__id = isys_logbook__id
			INNER JOIN isys_logbook_source ON isys_logbook_source__id = isys_logbook__isys_logbook_source__id
			WHERE (
			    isys_logbook_source__const = 'C__LOGBOOK_SOURCE__RELOCATE_CI'
                OR isys_logbook__changes LIKE '%C__CATG__LOCATION_PARENT%'
                OR isys_logbook__changes LIKE '%C__CMDB__CATG__LOGICAL_UNIT__PARENT%'
                OR isys_logbook__changes LIKE '%isys_cmdb_dao_category_g_location::parent%'
                OR isys_logbook__changes LIKE '%isys_cmdb_dao_category_g_logical_unit::parent%'
            )
            AND isys_catg_logb_list__isys_obj__id = {$objectId}
			ORDER BY isys_logbook__date DESC;";

        return $this->retrieve($l_sql);
    }

    /**
     * @param $p_row
     *
     * @return string
     * @throws isys_exception_database
     */
    public function dynamic_property_callback_changed($p_row)
    {
        if (!isset($p_row['__id__']) || !is_numeric($p_row['__id__']) || !($p_row['__id__'] > 0)) {
            return '-';
        }

        $result = $this->getLogbookInfoResult($p_row['__id__']);

        if (!$result->count()) {
            return '-';
        }

        $lang = isys_application::instance()->container->get('language');
        $html = '';
        while ($row = $result->get_row()) {
            // @see RELOCATE-42
            // @todo Update this code to use 'Unserialize::toArray()' after i-doit 25 release.
            $changes = unserialize($row['isys_logbook__changes'], ['allowed_classes' => false]);
            $from = $changes['isys_cmdb_dao_category_g_location::parent']['from'] ?? \isys_tenantsettings::get('gui.empty_value', '-');
            $to = $changes['isys_cmdb_dao_category_g_location::parent']['to'] ?? \isys_tenantsettings::get('gui.empty_value', '-');
            $time = $row['isys_logbook__date'];
            $objName = $row['isys_logbook__obj_name_static'];
            $objType = $lang->get($row['isys_logbook__obj_type_static']);
            $translation = $lang->get('LC__RELOCATE_CI__NICE_LOGBOOK_INFO');
            $html .= str_replace([':time', ':objType', ':objName', ':from', ':to'], [$time, $objType, $objName, $from, $to], $translation) . PHP_EOL;
        }

        return $html;
    }
}
