<?php

use idoit\Module\RelocateCi\Controller\RelocateCheckController;
use idoit\Module\RelocateCi\Controller\SuggestionController;
use idoit\Module\RelocateCi\Controller\TreeController;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    $routes->add('relocate_ci.suggestion', '/relocate-ci/suggestion')
        ->methods(['POST'])
        ->controller([SuggestionController::class, 'getChoices']);

    $routes->add('relocate_ci.tree.get-path', '/relocate-ci/get-tree-path')
        ->methods(['GET'])
        ->controller([TreeController::class, 'getPath']);

    $routes->add('relocate_ci.pre-relocate-check', '/relocate-ci/check-validity')
        ->methods(['POST'])
        ->controller([RelocateCheckController::class, 'checkValidity']);
};
