<?php

use idoit\AddOn\AuthableInterface;
use idoit\Module\RelocateCi\Model\Ci;

/**
 * i-doit
 *
 * Relocate CI module class.
 *
 * @package     modules
 * @subpackage  relocate_ci
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_relocate_ci extends isys_module implements AuthableInterface
{
    // Define, if this module shall be displayed in the named menus.
    const DISPLAY_IN_MAIN_MENU   = true;
    const DISPLAY_IN_SYSTEM_MENU = false;

    /**
     * Initializes the module.
     *
     * @param   isys_module_request & $p_req
     *
     * @return  isys_module_relocate_ci
     */
    public function init(isys_module_request $p_req)
    {
        return $this;
    }

    /**
     * This method builds the tree for the menu.
     *
     * @param   isys_component_tree $p_tree
     * @param   boolean             $p_system_module
     * @param   integer             $p_parent
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     * @see     isys_module_cmdb->build_tree();
     */
    public function build_tree(isys_component_tree $p_tree, $p_system_module = true, $p_parent = null)
    {
        global $g_dirs;

        if ($p_system_module === false) {
            $l_cnt = 1;
            $l_auth = isys_auth_relocate_ci::instance();

            // At first we create the base
            $l_root = $p_tree->add_node(
                C__MODULE__RELOCATE_CI . 0,
                $p_parent,
                $this->language->get('LC__MODULE__RELOCATE_CI'),
                '',
                '',
                self::getWwwPath() . 'assets/add-on-icon.svg'
            );

            $p_tree->add_node(
                C__MODULE__RELOCATE_CI . $l_cnt,
                $l_root,
                $this->language->get('LC__MODULE__RELOCATE_CI__RELOCATE_GUI'),
                isys_helper_link::create_url([
                    C__GET__MODULE_ID     => C__MODULE__RELOCATE_CI,
                    C__GET__TREE_NODE     => C__MODULE__RELOCATE_CI . $l_cnt,
                    C__GET__SETTINGS_PAGE => 'relocate_ci'
                ]),
                '',
                $g_dirs['images'] . 'axialis/transportation/delivery.svg',
                true,
                '',
                '',
                $l_auth->is_allowed_to(isys_auth::EXECUTE, 'relocate_gui')
            );

            $l_cnt++;

            $p_tree->add_node(
                C__MODULE__RELOCATE_CI . $l_cnt,
                $l_root,
                $this->language->get('LC__MODULE__RELOCATE_CI__LOGBOOK_GUI'),
                isys_helper_link::create_url([
                    C__GET__MODULE_ID     => C__MODULE__RELOCATE_CI,
                    C__GET__TREE_NODE     => C__MODULE__RELOCATE_CI . $l_cnt,
                    C__GET__SETTINGS_PAGE => 'logbook'
                ]),
                '',
                $g_dirs['images'] . 'axialis/basic/book-open.svg',
                true,
                '',
                '',
                $l_auth->is_allowed_to(isys_auth::VIEW, 'relocate_logbook')
            );
        }
    }

    /**
     * Start method.
     *
     * @return  isys_module_relocate_ci
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function start()
    {
        global $g_active_modreq;

        // Build the module tree, but only if we are not in the system-module.
        if ($_GET[C__GET__MODULE_ID] != C__MODULE__SYSTEM) {
            $l_tree = $g_active_modreq->get_menutree();
            $this->build_tree($l_tree, false, -1);

            isys_application::instance()->container->get('template')->assign("menu_tree", $l_tree->process($_GET[C__GET__TREE_NODE]));
        }

        switch ($_GET[C__GET__SETTINGS_PAGE]) {
            default:
            case 'relocate_ci':
                isys_auth_relocate_ci::instance()
                    ->check(isys_auth::VIEW, 'relocate_gui');
                $this->process_relocate_gui();
                break;

            case 'logbook':
                isys_auth_relocate_ci::instance()
                    ->check(isys_auth::VIEW, 'relocate_logbook');
                $this->process_logbook_gui();
                break;
        }

        return $this;
    }

    /**
     * Method for displaying the "Relocate-CI" GUI.
     */
    protected function process_relocate_gui()
    {
        $routeGenerator = isys_application::instance()->container->get('route_generator');

        // Creating some frontend rules.
        $l_rules = [
            'module-relocate-ci-source-search' => [
                'size' => 'block',
                'url' => $routeGenerator->generate('relocate_ci.suggestion')
            ],
            'module-relocate-ci-target-search' => [
                'size' => 'block',
                'url' => $routeGenerator->generate('relocate_ci.suggestion')
            ]
        ];

        isys_application::instance()->container->get('template')
            ->activate_editmode()
            ->assign('content_title', $this->language->get('LC__MODULE__RELOCATE_CI__RELOCATE_GUI'))
            ->assign('ajaxGetPathUrl', $routeGenerator->generate('relocate_ci.tree.get-path'))
            ->assign('ajaxPreRelocateCheckUrl', $routeGenerator->generate('relocate_ci.pre-relocate-check'))
            ->assign('has_right', isys_auth_relocate_ci::instance()->is_allowed_to(isys_auth::EXECUTE, 'relocate_gui'))
            ->smarty_tom_add_rules('tom.content.bottom.content', $l_rules)
            ->include_template('contentbottomcontent', self::getPath() . 'templates/relocate_gui.tpl');

        isys_component_template_navbar::getInstance()
            ->append_button('LC__MODULE__RELOCATE_CI__RELOCATE_GUI_NAVBAR_BUTTON', '', [
                'tooltip'     => $this->language->get('LC__MODULE__RELOCATE_CI__RELOCATE_GUI_NAVBAR_BUTTON'),
                'icon'        => 'axialis/transportation/delivery.svg',
                'js_onclick'  => "this.fire('relocate:trigger');",
                'js_function' => 'js_function;',
                'navmode'     => 'relocate'
            ]);
    }

    /**
     * Method for displaying the "Relocate-CI Logbook" GUI.
     */
    protected function process_logbook_gui()
    {
        $relocateCiLogbookSql = "SELECT * FROM isys_logbook
            INNER JOIN isys_catg_logb_list ON isys_catg_logb_list__isys_logbook__id = isys_logbook__id
            INNER JOIN isys_logbook_source ON isys_logbook_source__id = isys_logbook__isys_logbook_source__id
            WHERE isys_logbook_source__const = 'C__LOGBOOK_SOURCE__RELOCATE_CI'
            OR isys_logbook__changes LIKE '%C__CATG__LOCATION_PARENT%'
            OR isys_logbook__changes LIKE '%C__CMDB__CATG__LOGICAL_UNIT__PARENT%'
            OR isys_logbook__changes LIKE '%isys_cmdb_dao_category_g_location::parent%'
            OR isys_logbook__changes LIKE '%isys_cmdb_dao_category_g_logical_unit::parent%'
            ORDER BY isys_logbook__date DESC;";

        $l_res = isys_application::instance()->container->get('cmdb_dao')->retrieve($relocateCiLogbookSql);

        isys_application::instance()->container->get('template')
            ->activate_editmode()
            ->assign('content_title', $this->language->get('LC__MODULE__RELOCATE_CI__LOGBOOK_GUI'))
            ->assign('result', $l_res)
            ->assign('empty_result', 'LC__CATG__VIRTUAL_RELOCATE_CI__NO_CI_LOGS')
            ->include_template('contentbottomcontent', self::getPath() . 'templates/relocate_logbook.tpl');
    }

    /**
     * @return isys_auth_relocate_ci
     */
    public static function getAuth()
    {
        return isys_auth_relocate_ci::instance();
    }
}
