<?php

namespace idoit\Module\RelocateCi\Controller;

use Exception;
use idoit\Module\RelocateCi\Model\Tree;
use isys_application;
use isys_tenantsettings;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 *
 */
class SuggestionController
{
    /**
     * Find located devices (both physical and logical) in the tree.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function getChoices(Request $request): Response
    {
        try {
            $results = [];

            $separator = isys_tenantsettings::get('gui.separator.location', ' > ');
            $treeModel = Tree::instance(isys_application::instance()->container->get('database'));
            $treeModel->findObject($request->request->get('search'));

            $result = $treeModel->findObject($request->request->get('search'));


            while ($row = $result->get_row()) {
                if ($row['physical'] > 0) {
                    $path = $treeModel->getPhysicalPath((int)$row['objectId']);
                    $results['physical:' . $row['objectId']] = implode($separator, array_map(fn ($item) => $item['title'], $path));
                }

                if ($row['logical'] > 0) {
                    $path = $treeModel->getLogicalPath((int)$row['objectId']);
                    $results['logical:' . $row['objectId']] = implode($separator, array_map(fn ($item) => $item['title'], $path));
                }
            }

            return new JsonResponse([
                'success' => true,
                'data'    => $results,
                'message' => ''
            ]);
        } catch (Exception $e) {
            return new JsonResponse([
                'success' => false,
                'data'    => null,
                'message' => $e->getMessage()
            ]);
        }
    }
}
